% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_mantelhaen_test.R
\name{ard_stats_mantelhaen_test}
\alias{ard_stats_mantelhaen_test}
\title{ARD Cochran-Mantel-Haenszel Chi-Squared Test}
\usage{
ard_stats_mantelhaen_test(data, by, variables, strata, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be computed for each variable.}

\item{strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to stratify by.}

\item{...}{additional arguments passed to \code{stats::mantelhaen.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Cochran-Mantel-Haenszel Chi-Squared Test for count data.
Calculated with \code{mantelhaen.test(x = data[[variables]], y = data[[by]], z = data[[strata]], ...)}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
cards::ADSL |>
  ard_stats_mantelhaen_test(by = "ARM", variables = "AGEGR1", strata = "SEX")
\dontshow{\}) # examplesIf}
}
