% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{sanitize_svg_for_raster}
\alias{sanitize_svg_for_raster}
\title{Sanitize SVG for rasterization engines (librsvg / ImageMagick)}
\usage{
sanitize_svg_for_raster(svg_input)
}
\arguments{
\item{svg_input}{An SVG string or an object coercible to character
(e.g. \code{htmltools::HTML}).}
}
\value{
A character string containing a sanitized SVG.
}
\description{
SVGs exported by editors such as Inkscape may contain \verb{sodipodi:*} and/or
\verb{inkscape:*} nodes/attributes. If these namespace prefixes appear without the
corresponding \verb{xmlns:*} declarations, strict parsers (notably \code{librsvg}) can
fail with errors like:
\preformatted{Namespace prefix sodipodi on namedview is not defined}

This helper removes non-rendering metadata blocks and attributes commonly
responsible for parse failures, producing a more interoperable SVG string.
It also removes Google Fonts @import rules which are not supported by
rasterization engines.
}
\keyword{internal}
