% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{batch_svg_to_png_chrome}
\alias{batch_svg_to_png_chrome}
\title{Batch convert SVGs to PNG files using headless Chrome}
\usage{
batch_svg_to_png_chrome(
  svg_list,
  output_paths = NULL,
  dpi = 300,
  background = "transparent",
  load_wait = 0.5,
  restart_every = 50,
  retry_attempts = 3,
  progress = TRUE
)
}
\arguments{
\item{svg_list}{List of SVG strings or file paths.}

\item{output_paths}{Character vector of output paths. If NULL, temp files are created.}

\item{dpi}{Resolution (default 300).}

\item{background}{Background color (default "transparent").}

\item{load_wait}{Seconds to wait for each page to load (default 0.5).
Increase if conversions are failing.}

\item{restart_every}{Restart Chrome session every N conversions (default 50).}

\item{retry_attempts}{Number of retry attempts on failure (default 3).}

\item{progress}{Show progress bar (default TRUE).}
}
\value{
Character vector of output file paths. Returns NA for failed conversions.
}
\description{
Converts multiple SVGs to PNG files using a single Chrome session.
Much faster than calling svg_to_png_chrome() repeatedly.
}
