% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor-fit.R
\name{cosinor_goodness_of_fit}
\alias{cosinor_goodness_of_fit}
\title{Goodness of Fit of Cosinor}
\usage{
cosinor_goodness_of_fit(object, level = 0.95, ...)
}
\arguments{
\item{object}{requires cosinor model generated with \link{cosinor} to
calculate statistics.}

\item{level}{confidence level desired}

\item{...}{additional parameters may be needed for extensibility}
}
\value{
f-statistic as result of goodness of fit
}
\description{
Goodness of fit of a cosinor from data that has multiple
collections at different timepoints or from multiple cycles. The RSS is
partitioned into pure error (SSPE) and lack of fit (SSLOF). An F-test
compares the SSPE and SSLOF to detect appropriateness of model.

\deqn{SSLOF = RSS - SSPE}

\deqn{SSPE = \sum_{i} \sum_{l} ( Y_{il} - \overline{Y}_{i} )^2}

The fitted values for each time point are:
\deqn{\overline{Y}_{i} = \frac{ \sum_{l} Y_{il} }{ n_{i}}}
}
