% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CADBCD_Alloc_Surv}
\alias{CADBCD_Alloc_Surv}
\title{Allocation Function of Covariate Adjusted Doubly Biased Coin Design for Survival Response}
\usage{
CADBCD_Alloc_Surv(ptsb.cov, ptsb.t, ptsb.Y, ptsb.E, ptnow.cov, v = 2, target)
}
\arguments{
\item{ptsb.cov}{a \code{n x k} covariate matrix of previous patients.}

\item{ptsb.t}{a treatment vector of previous patients with length \code{n}.}

\item{ptsb.Y}{a response vector of previous patients with length \code{n}.}

\item{ptsb.E}{a censoring indicator vector (1 = event observed, 0 = censored)with length \code{n}.}

\item{ptnow.cov}{a covariate vector of the incoming patient with length \code{k}.}

\item{v}{a non-negative integer that controls the randomness of CADBCD design. The default value is 2.}

\item{target}{the type of optimal allocation target. Options are \code{"Neyman"} or \code{"RSIHR"}.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses
for Covariate Adjusted Doubly Biased Coin procedure for survival trial.
}
\details{
For the first \eqn{m = 2m_0} patients, a restricted randomization procedure is used to allocate them equally to treatments A and B.

After the initial enrollment of \eqn{2m_0} patients, adaptive treatment assignment begins from patient \eqn{2m_0 + 1} onward. Importantly, this adaptive assignment does \emph{not} require complete observation of outcomes from earlier patients. Instead, at each new patient arrival, the treatment effect parameters \eqn{(\tilde{\boldsymbol{\beta}}_{A,m}, \tilde{\boldsymbol{\beta}}_{B,m})} are re-estimated via partial likelihood using the accrued survival data subject to \emph{dynamic administrative censoring}. Specifically, each previously enrolled patient is censored at the current arrival time if their event has not yet occurred. These updated estimates are then used to guide covariate-adjusted allocation.

When the \eqn{(m+1)}-th patient enters the trial with covariate vector \eqn{\boldsymbol{Z}_{m+1}}, the probability of assigning this patient to treatment A is computed as:
\deqn{
\phi_{m+1} = g(\tilde{\boldsymbol{\beta}}_{A,m}, \tilde{\boldsymbol{\beta}}_{B,m}, \boldsymbol{Z}_{m+1}),
}
where \eqn{0 \leq g(\cdot) \leq 1} is an appropriately chosen allocation function that favors the better-performing treatment arm.

Following Zhang and Hu's CADBCD procedure, let \eqn{N_A(m)} and \eqn{N_B(m) = m - N_A(m)} denote the numbers of patients allocated to treatments A and B after \eqn{m} assignments. Let \eqn{\tilde{\pi}_m = \pi_A(\tilde{\boldsymbol{\beta}}_{A,m}, \tilde{\boldsymbol{\beta}}_{B,m}, \boldsymbol{Z}_{m+1})} be the target allocation probability for the incoming patient. The average target allocation proportion among the first \eqn{m} patients is defined as:
\deqn{
\tilde{\rho}_m = \frac{1}{m} \sum_{i=1}^m \pi_A(\tilde{\boldsymbol{\beta}}_{A,m}, \tilde{\boldsymbol{\beta}}_{B,m}, \boldsymbol{Z}_i).
}

Under the CADBCD scheme, the probability of assigning treatment A to the \eqn{(m+1)}-th patient is given by:
\deqn{
\phi_{m+1} = \frac{\tilde{\pi}_m \left( \frac{\tilde{\rho}_m}{N_A(m)/m} \right)^v}
{\tilde{\pi}_m \left( \frac{\tilde{\rho}_m}{N_A(m)/m} \right)^v + (1 - \tilde{\pi}_m) \left( \frac{1 - \tilde{\rho}_m}{N_B(m)/m} \right)^v},
}
and to treatment 2 with probability \eqn{\psi_{m+1,2} = 1 - \psi_{m+1,1}}, where \eqn{v \geq 0} is a constant controlling the degree of randomness—from the most random when \eqn{v = 0} to the most deterministic when \eqn{v \rightarrow \infty}.
similiar procedure for survival responses are used in all other designs.
}
\examples{
set.seed(123)
n = 40
covariates = cbind(rexp(40),rexp(40))
treatment = sample(c(0, 1), n, replace = TRUE)
survival_time = rexp(n, rate = 1)
censoring = runif(n)
event = as.numeric(survival_time < censoring)
new_patient_cov = c(Z1 = 1, Z2 = 0.5)
result = CADBCD_Alloc_Surv(
 ptsb.cov = covariates,
 ptsb.t = treatment,
 ptsb.Y = survival_time,
 ptsb.E = event,
 ptnow.cov = new_patient_cov,
 v = 2,
 target = "Neyman"
)
print(result$prob)
}
\references{
Mukherjee, A., Jana, S., & Coad, S. (2024). Covariate-adjusted response-adaptive designs for semiparametric survival models.
\emph{Statistical Methods in Medical Research}, 09622802241287704.
}
\concept{CADBCD Design}
