% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{BICcapushe}
\alias{BICcapushe}
\title{BICcapushe}
\usage{
BICcapushe(data,n)
}
\arguments{
\item{data}{\code{data} is a matrix or a data.frame with four columns of the same length
and each line corresponds to a model:
  \enumerate{
\item The first column contains the model names.
\item The second column contains the penalty shape values.
\item The third column contains the model complexity values.
\item The fourth column contains the minimum contrast value for each model.
  }}

\item{n}{\code{n} is the sample size.}
}
\value{
model The model selected by BIC.
}
\description{
These functions return the model selected by the Bayesian Information Criterion (BIC).
}
\details{
The penalty shape value should be increasing with respect to the complexity value (column 3).
The complexity values have to be positive.
\code{n} is necessary to compute AIC and BIC criteria. \code{n} is the size of
sample used to compute the contrast values given in the \code{data} matrix.
Do not confuse \code{n} with the size of the model collection which is the number
of rows of the \code{data} matrix.
}
\examples{
data(datacapushe)
BICcapushe(datacapushe,n=1000)
}
