% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_behaviour.R
\name{get_db_score}
\alias{get_db_score}
\title{Compute a daily behaviour domain score.}
\usage{
get_db_score(step_score = NA, self_report_pa_score = NA)
}
\arguments{
\item{step_score}{A numeric (integer) vector representing the pedometer steps score (valid values are integers between 0 and 25).}

\item{self_report_pa_score}{A numeric (integer) vector representing the self-reported physical activity score (valid values are
integers between 0 and 5).}
}
\value{
Returns a numeric (integer) vector with values between 0 and 30 (if valid) or NA (if not valid).
}
\description{
This function computes a daily behaviour domain score (\code{db_score}) based on the step and self-reported physical activity scores. This score
is used to compute the overall physical literacy score (\code{capl_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_db_score(
  step_score = c(20, 6, 13, 5, NA, 4.5),
  self_report_pa_score = c(3, 2, 1, 4, 7, 3)
)

# [1] 23  8 14  9 NA NA

}
