% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{biod_example}
\alias{biod_example}
\title{Biodiverse example data}
\format{
A list with two elements:
\describe{
\item{phy}{Phylogeny with 31 tips}
\item{comm}{Community matrix with 127 sites and 31 species.
Data are counts, i.e., the number of times
a species was observed in a grid cell.}
}
}
\usage{
biod_example
}
\description{
Fictional data for testing purposes from
\href{https://github.com/shawnlaffan/biodiverse/tree/master/data}{Biodiverse}.
}
\details{
Corresponds to the the community matrix ("groups" object) and phylogeny from
the Biodiverse \href{https://github.com/shawnlaffan/biodiverse/raw/fbcad3c1df3667bac1235e822cb48ef6e5884e66/data/example_project.bps}{example_project.bps}.  # nolint
}
\examples{
# Example phylogeny
biod_example$phy
# Example community
biod_example$comm[1:5, 1:5]
}
\references{
Laffan, S.W., Lubarsky, E. & Rosauer, D.F. (2010) Biodiverse, a
tool for the spatial analysis of biological and related diversity.
Ecography. Vol 33, 643-647 (Version 3.1).
\doi{10.1111/j.1600-0587.2010.06237.x}
}
\keyword{datasets}
