% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.wave.R
\name{load.wave}
\alias{load.wave}
\title{load.wave}
\usage{
load.wave(path_audio_file, from = 0, to = Inf, ffilter_from = NULL)
}
\arguments{
\item{path_audio_file}{the path to the .wav file}

\item{from}{time in seconds from where to start the loading of the audio file.
Default is `0` which loads the whole file.}

\item{to}{time in seconds until where to load the audio file. Default is `Inf` which loads the whole file.}

\item{ffilter_from}{numeric, frequency in Hz for the high-pass filter.
Default is `NULL`, which does not apply a filter.}
}
\value{
Returns an R wave object.
}
\description{
Wrapper function for `readWave` from *tuneR*.
Also optionally applies `ffilter` from *seewave*.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = load.wave(local_file_1)

}
