% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-main.R
\name{calibration_data}
\alias{calibration_data}
\title{Get observed data for the calibration of a model}
\usage{
calibration_data(setup, path = ".", file = NULL, verbose = TRUE, ...)
}
\arguments{
\item{setup}{A data.frame with the information about the calibration, 
normally created with the \code{\link{calibration_setup}} function. 
See details.}

\item{path}{Path to the directory to look up for the data. Paths in setup are considered relatives to this path.}

\item{file}{Optional file to save the created object (as an 'rds' file.)}

\item{verbose}{If TRUE, detailed messages of the process are printed.}

\item{\dots}{Additional arguments to \code{read.csv} function 
to read the data files.}
}
\value{
A list with the observed data needed for a calibration, to be used 
in combination with the \code{\link{calibration_objFn}}.
}
\description{
Create a list with the observed data with the 
information provided by its main argument.
}
\seealso{
\code{\link{calibration_objFn}}, \code{\link{calibration_setup}}.
}
\author{
Ricardo Oliveros-Ramos
}
