test_that("balinese", {
  dates <- gregorian_date(2025, 6, 15:16) |> vctrs::vec_data()
  bdates <- as_balinese(dates) |> as.list()
  expect_equal(bdates$luang, c(FALSE, FALSE))
  expect_equal(bdates$dwiwara, c(1, 1))
  expect_equal(bdates$triwara, c(1, 2))
  expect_equal(bdates$caturwara, c(1, 2))
  expect_equal(bdates$pancawara, c(3, 4))
  expect_equal(bdates$sadwara, c(1, 2))
  expect_equal(bdates$saptawara, c(1, 2))
  expect_equal(bdates$asatawara, c(5, 6))
  expect_equal(bdates$sangawara, c(7, 8))
  expect_equal(bdates$dasawara, c(3, 9))
  # Tumpek
  tumpek2025 <- tumpek(2025)
  expect_equal(diff(tumpek2025), rep(35, 9))
  expect_equal(tumpek2025[1], gregorian_date(2025, 1, 18))
  # Kajeng Keliwon
  kk2025 <- kajeng_keliwon(2025)
  expect_equal(diff(kk2025), rep(15, 24))
  expect_equal(kk2025[1], gregorian_date(2025, 1, 3))
})
