% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cristin_monthly.R
\name{CristinMonthly}
\alias{CristinMonthly}
\title{Create a month-to-month bibliography of selected units}
\usage{
CristinMonthly(
  zotero,
  unit.key,
  style = "apa-single-spaced",
  locale = "nn-NO",
  start.date = Sys.Date(),
  end.date = NULL,
  use.filter = TRUE,
  filter = NULL,
  nvi = TRUE,
  user.cards = FALSE,
  use.identifiers = TRUE,
  zotero.check = FALSE,
  lang = "nn",
  post = FALSE,
  create.email = FALSE,
  create.web = FALSE,
  subject = NULL,
  header = NULL,
  footer = NULL,
  replace.style = TRUE,
  width = 700,
  silent = FALSE,
  log = list()
)
}
\arguments{
\item{zotero}{What Zotero library to use}

\item{unit.key}{What unit to search for}

\item{style}{Citation style to use for appended bibliography and/or
citations, Default: 'apa-single-spaced'}

\item{locale}{Desired language format of bibliography, Default: 'nn-NO'}

\item{start.date}{Results created from specified date (YYYY-MM),
Default: Sys.Date()}

\item{end.date}{Results created before specified date (YYYY-MM),
Default: NULL}

\item{use.filter}{Filter out specific items (otherwise supported by
`CristinWrangler`), Default: TRUE}

\item{filter}{Filter out specific item types, will default to item types
usually associated with NVI, Default: NULL}

\item{nvi}{Filter out Cristin items not 1/2 in NVI, Default: TRUE}

\item{user.cards}{Get business cards of contributors (currently INN),
Default: FALSE}

\item{use.identifiers}{Use if ISBN/DOI identifiers if enabled, Default: TRUE}

\item{zotero.check}{Check if Cristin items exists in Zotero library
, Default: FALSE}

\item{lang}{Set Cristin language (nn, nb, en), Default: 'nn'}

\item{post}{Post new items to specified Zotero library, Default: FALSE}

\item{create.email}{Create HTML output for email, Default: FALSE}

\item{create.web}{Create HTML output for web, Default: FALSE}

\item{subject}{Add a custom subject to email, Default: NULL}

\item{header}{Add a custom header to email, Default: NULL}

\item{footer}{Add a custom footer to email, Default: NULL}

\item{replace.style}{Email clients (e.g., Outlook) is poor at rendering CSS,
and the default setting is to remove hanging indent, Default: TRUE}

\item{width}{Width of email in pixels, Default: 700}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A list with bibliography and information for defined units
}
\description{
Create a bibliography in a newsletter format from month-to-month
From either a specified unit or a set of units (e.g., A University ->
Faculties -> Departments -> Groups). The function has the ability to create
HTML output designed for emails and/or webpages.
}
\details{
Please see
\href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Dummy example
  newsletter <- CristinMonthly(
    Zotero(
      id = "4827927",
      api = "RqlAmlH5l1KPghfCseAq1sQ1"
    ),
    "209.0.0.0"
  )
}
}
\seealso{
\code{\link[dplyr]{filter}}, \code{\link[dplyr]{arrange}},
 \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{bind_rows}},
 \code{\link[dplyr]{bind_cols}}, \code{\link[dplyr]{select}},
 \code{\link[dplyr]{group_by}}, \code{\link[dplyr]{case_when}},
 \code{\link[dplyr]{context}}, \code{\link[dplyr]{distinct}},
 \code{\link[dplyr]{pull}}, \code{\link[dplyr]{mutate-joins}},
 \code{\link[dplyr]{join_by}}, \code{\link[dplyr]{rename}},
 \code{\link[dplyr]{across}}, \code{\link[dplyr]{reexports}},
 \code{\link[dplyr]{mutate_all}}
 \code{\link[purrr]{pmap}}, \code{\link[purrr]{map}}
 \code{\link[tibble]{tibble}}
 \code{\link[stats]{setNames}}
}
