% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_model2df.R
\docType{methods}
\name{model2df}
\alias{model2df}
\alias{model2df,list-method}
\alias{model2df,-methods}
\title{Convert model from list to data frame}
\usage{
model2df(model = get_model(), factorize = TRUE)

\S4method{model2df}{list}(model = get_model(), factorize = TRUE)
}
\arguments{
\item{model}{A named list describing a transaction model.}

\item{factorize}{Logical,
      whether columns not representing a transaction type should be returned as a factor.}
}
\value{
A data frame,
      representing the model structure that was defined with \code{\link[businessPlanR:table_model]{table_model}}.
}
\description{
Converting a model from list format into a data frame makes it easier to work with nested sub-positions,
and to check the model for completeness.
}
\details{
The list provided must have named entries which form the top level of the transaction model.
Values are in turn a list with optional named arguments:
\itemize{
   \item{\code{subpos} }{A named list, nested sub-position to this level,
      structured like any higher level position.}
   \item{\code{carry} }{Name of a previous position of the same level,
      its value is used as the starting value of this position.}
   \item{\code{revenue} }{Character vecotor of valid revenue types,
      their values are added to the position total.}
   \item{\code{expense} }{Character vecotor of valid expense types,
      their values are subtracted from the position total.}
}
}
