% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/challenges.R
\docType{data}
\name{challenges}
\alias{challenges}
\title{IACGMOOH celebrity challenges data}
\format{
\subsection{\code{challenges}}{

A data frame with 134 rows and 7 columns:
\describe{
\item{season}{(\emph{numeric}) Season of the show}
\item{episode}{(\emph{numeric}) Episode in which the challenge occurred}
\item{date}{(\emph{Date}) Date the challenge took place (where available)}
\item{contestant}{(\emph{character}) First name(s) of the contestant(s) that took part in the challenge.
Where there are multiple contestants, they are separated by a semi-colon.}
\item{prizes_available}{(\emph{character}) The prize(s) which were on offer for completion of the
challenge. For some challenges the competing contestants were given a choice between one or more
prize options - in these cases the options are separated by a semi-colon.}
\item{prize}{(\emph{character}) The prize(s) which was on offer, either because the contestants
chose it, or because it was the only prize on offer.}
\item{question}{(\emph{character}) Outcome of the question that gets asked to the non-participating
celebrities. One of: 'correct' if the non-participants answered correctly and won the prize;
'incorrect' if the non-participants answered incorrectly and forfeited the prize; or 'not_asked'
if no question was asked to non-participants (the outcome of some challenges is decided by other
means).}
}
}
}
\source{
\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_1}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_2}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_3}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_4}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_5}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_6}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_7}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_8}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_9}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_10}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_11}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_12}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_13}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_14}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_15}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_16}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_17}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_18}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_19}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_20}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_21}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_22}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_23}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_24}
}
\usage{
challenges
}
\description{
Data on each of the celebrity challenges (Celebrity Chest, Dingo Dollar,
Castle Coin or Deals on Wheels) in the first 24 seasons of the
UK TV show "I'm A Celebrity, Get Me Out Of Here"
}
\examples{
{
 # How many challenge questions have been answered correctly
 table(challenges$question)

 # How many times was chocolate the prize
 sum(grepl("choc", challenges$prize, ignore.case = TRUE))
}
}
\keyword{datasets}
