% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_mudab.R
\name{mudab_parameter_values}
\alias{mudab_parameter_values}
\title{List MUDAB parameter values}
\usage{
mudab_parameter_values(
  filter = NULL,
  range = NULL,
  orderby = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{filter}{Optional filter definition.}

\item{range}{Optional range specification.}

\item{orderby}{Optional ordering specification.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with parameter values.

Includes \code{datetime_time} as POSIXct in Europe/Berlin when date/time fields are
present.
}
\description{
List MUDAB parameter values
}
\details{
Returns measurement values for parameters from the MUDAB database.
Official docs: https://mudab.api.bund.dev.
}
\examples{
\dontrun{
mudab_parameter_values(range = list(from = 0, count = 5))
}

}
