% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_charging_stations}
\alias{autobahn_charging_stations}
\title{List Autobahn charging stations}
\usage{
autobahn_charging_stations(road_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{road_id}{Road identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with charging stations.
}
\description{
List Autobahn charging stations
}
\details{
Returns charging stations for a specific Autobahn road id.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
autobahn_charging_stations(roads$road_id[[1]], flatten = TRUE)
}
}
\seealso{
\code{\link[=autobahn_roads]{autobahn_roads()}} and \code{\link[=autobahn_charging_station_details]{autobahn_charging_station_details()}}.
}
