% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_toast}
\alias{bs_toast}
\title{Create a Bootstrap toast}
\usage{
bs_toast(
  id,
  header,
  body,
  default_close_button = TRUE,
  on_load = TRUE,
  toast_attr = c(class = "toast", role = "alert", `aria-live` = "assertive",
    `aria-atomic` = "true", `data-bs-autohide` = "false"),
  header_attr = c(class = "toast-header"),
  body_attr = c(class = "toast-body")
)
}
\arguments{
\item{id}{A string, the id for the div of the toast.}

\item{header}{A string, the HTML to display in the header of the toast.}

\item{body}{A string, the HTML to display in the body of the toast.}

\item{default_close_button}{TRUE/FALSE, if TRUE, adds code to display the default toast close button, otherwise the close button should be added manually.}

\item{on_load}{TRUE/FALSE, if TRUE, adds a script tag with javascript to show the toast by id on load.}

\item{toast_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the toast content.}

\item{header_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the toast header.}

\item{body_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the toast body.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap toast
}
\examples{
bs_toast(
id = "toast1",
header = "Hello",
body = "This is a toast"
)
}
