% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_pagination}
\alias{bs_pagination}
\title{Create a Bootstrap pagination nav}
\usage{
bs_pagination(
  items = list(),
  ul_attr = c(class = "pagination"),
  li_attr = c(class = "page-item"),
  a_attr = c(class = "page-link")
)
}
\arguments{
\item{items}{A list, creates nav elements. If a list item is named, names should be links
and values should be text to display in the pagination bar for that link. Names will be passed to the
href attribute and values to the main content of the html5::a function which will be wrapped by the html5::li function,
each of which have Bootstrap classes added by default. If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually.}

\item{ul_attr}{A named list or named vector, names are attribute names and values are attribute values. Used for the "ul" tag wrapping the nav elements.}

\item{li_attr}{A named list or named vector, names are attribute names and values are attribute values. Used for the "li" tags wrapping the nav elements if the input list item is named.}

\item{a_attr}{A named list or named vector, names are attribute names and values are attribute values. Used for the "a" tags wrapping the nav elements if the input list item is named.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/pagination/}.
}
\examples{
bs_pagination(
items = list(
  "#" = "Previous",
  "#" = "1",
  "#" = "2",
  "#" = "3",
  "#" = "Next"
)
)
}
