% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4Badge}
\alias{bs4Badge}
\alias{dashboardBadge}
\title{Create a Bootstrap 4 dashboard badge item}
\usage{
bs4Badge(..., color, position = c("left", "right"), rounded = FALSE)

dashboardBadge(..., color, position = c("left", "right"), rounded = FALSE)
}
\arguments{
\item{...}{Badge content.}

\item{color}{Badge color. Valid colors:
\itemize{
\item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
\item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
\item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
\item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
\item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
\item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
}}

\item{position}{Badge position: \code{"left"} or \code{"right"}.}

\item{rounded}{Whether the badge is rounded instead of square. FALSE by default.}
}
\description{
\link{dashboardBadge} creates a badge. It may be inserted in any element like inside
a \link[shiny]{actionButton} or a \link{dashboardSidebar}.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     dashboardBadge("Badge 1", color = "danger"),
     actionButton(
      inputId = "badge",
      label = "Hello",
      icon = NULL,
      width = NULL,
      dashboardBadge(1, color = "primary")
     )
    )
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
