% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-obs.R
\name{add_n_obs}
\alias{add_n_obs}
\title{Add the number of observations for each key in a \code{tsibble}}
\usage{
add_n_obs(.data, ...)
}
\arguments{
\item{.data}{tsibble}

\item{...}{extra arguments}
}
\value{
tsibble with \code{n_obs}, the number of observations per key added.
}
\description{
Here, we are not counting the number of rows in the dataset, but rather
we are counting the number observations for each keys in the data.
}
\examples{
library(dplyr)
# you can explore the data to see those cases that have exactly two
 # observations:
heights \%>\%
  add_n_obs() \%>\%
  filter(n_obs == 2)
}
