% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-Normalization.R
\name{BridgeRNormalizationFactors}
\alias{BridgeRNormalizationFactors}
\title{Calculate normalization factors for BRIC-seq datasets.}
\usage{
BridgeRNormalizationFactors(inputFile, group = c("Control", "Knockdown"),
  hour = c(0, 1, 2, 4, 8, 12), inforColumn = 4, save = T, YMin = -2,
  YMax = 2, downsamplingFig = 0.2, makeFig = FALSE,
  cutoffQuantile = 0.975, figOutputPrefix = "BridgeR_3_fig",
  factorOutputPrefix = "BridgeR_3")
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{inforColumn}{The number of information columns.}

\item{save}{Whether to save the output matrix file.}

\item{YMin}{Y-axis min.}

\item{YMax}{Y-axis max.}

\item{downsamplingFig}{the factor for downsampling.}

\item{makeFig}{Whether to save the figure of normalization factor.}

\item{cutoffQuantile}{cutoff value of quantile.}

\item{figOutputPrefix}{The prefix for the name of figure output.}

\item{factorOutputPrefix}{The prefix for the name of factor output.}
}
\value{
data.table object about normalization factors calculated by quantile method.
}
\description{
\code{BridgeRNormalizationFactors} calculates the normalization factors
for BRIC-seq datasets.
}
\examples{
library(data.table)
rpkm_matrix <- data.table(gr_id = c(8, 9, 14),
                          symbol = c("AAAS", "AACS", "AADAT"),
                          accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                          locus = c("chr12", "chr12", "chr4"),
                          CTRL_1_0h = c(41, 5, 5),
                          CTRL_1_1h = c(48, 7, 6),
                          CTRL_1_2h = c(56, 10, 6),
                          CTRL_1_4h = c(87, 12, 10),
                          CTRL_1_8h = c(124, 20, 11),
                          CTRL_1_12h = c(185, 22, 15),
                          gr_id = c(8, 9, 14),
                          symbol = c("AAAS", "AACS", "AADAT"),
                          accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                          locus = c("chr12", "chr12", "chr4"),
                          KD_1_0h = c(21, 10, 3),
                          KD_1_1h = c(33, 11, 3),
                          KD_1_2h = c(42, 15, 4),
                          KD_1_4h = c(60, 20, 5),
                          KD_1_8h = c(65, 37, 6),
                          KD_1_12h = c(70, 42, 6))
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
rpkm_list <- BridgeRDataSetFromMatrix(inputFile = rpkm_matrix,
                                      group = group,
                                      hour = hour,
                                      cutoff = 0.1,
                                      inforColumn = 4,
                                      save = FALSE)
raw_table <- rpkm_list[[1]]
test_table <- rpkm_list[[2]]
factor_table <- BridgeRNormalizationFactors(test_table,
                                            save = FALSE)

}

