% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraries.R
\name{db_libs_install}
\alias{db_libs_install}
\title{Install Library on Cluster}
\usage{
db_libs_install(
  cluster_id,
  libraries,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{Unique identifier of a Databricks cluster.}

\item{libraries}{An object created by \code{\link[=libraries]{libraries()}} and the appropriate
\verb{lib_*()} functions.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Install Library on Cluster
}
\details{
Installation is asynchronous - it completes in the background after the request.

This call will fail if the cluster is terminated. Installing a wheel library
on a cluster is like running the pip command against the wheel file directly
on driver and executors.

Installing a wheel library on a cluster is like running the pip command
against the wheel file directly on driver and executors. All the
dependencies specified in the library setup.py file are installed and this
requires the library name to satisfy the wheel file name convention.

The installation on the executors happens only when a new task is launched.
With Databricks Runtime 7.1 and below, the installation order of libraries
is nondeterministic. For wheel libraries, you can ensure a deterministic
installation order by creating a zip file with suffix .wheelhouse.zip that
includes all the wheel files.
}
\seealso{
\code{\link[=lib_egg]{lib_egg()}}, \code{\link[=lib_cran]{lib_cran()}}, \code{\link[=lib_jar]{lib_jar()}}, \code{\link[=lib_maven]{lib_maven()}}, \code{\link[=lib_pypi]{lib_pypi()}},
\code{\link[=lib_whl]{lib_whl()}}

Other Libraries API: 
\code{\link{db_libs_all_cluster_statuses}()},
\code{\link{db_libs_cluster_status}()},
\code{\link{db_libs_uninstall}()}
}
\concept{Libraries API}
