% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\name{bwr_cat_create}
\alias{bwr_cat_create}
\title{Upload a new category to Brandwatch}
\usage{
bwr_cat_create(project_id = NULL, name = NULL, children = NULL,
  token = Sys.getenv("BW_TOKEN"))
}
\arguments{
\item{project_id}{The project ID into which you'd like to insert a category}

\item{name}{The name of the category}

\item{children}{A list of lists (sorry!), each list defining the key-value pairs for name (mandatory) and
id (optional) of each child subcategory.}

\item{token}{The authentication token, obtained using bwr_auth()}
}
\value{
Returns a list containing the JSON response from the server.
}
\description{
Refer to https://developers.brandwatch.com/docs/creating-categories for
more information. Unless otherwise specified, provide a single string argument.
}
\examples{
\dontrun{bwr_cat_create(project_id = 12423432,
               name = 'Quick test cat',
               children = list(list(name = 'category one', id = 234234),
                 list(name = 'category 2')))}
}
