% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_elim.R
\name{single_elim}
\alias{single_elim}
\title{Create a single elimination bracket}
\usage{
single_elim(participants, ...)
}
\arguments{
\item{participants}{Character vector of participant names, or a data.frame
with a 'name' column and optional 'seed' column.}

\item{...}{Additional arguments passed to bracket constructors or
tournament stage-verb dispatch methods.}
}
\value{
A single_elim_bracket object
}
\description{
Single elimination (knockout) tournament where losing a match eliminates
the participant from the tournament.
}
\examples{
# Simple knockout bracket
trn <- tournament(paste("Team", LETTERS[1:8])) |>
  single_elim("bracket")

# Chain after group stage
trn <- tournament(c("A", "B", "C", "D")) |>
  round_robin("groups") |>
  single_elim("finals", take = top_n(2))
}
