
test_that("h(0) = 0 for difference", {
  h <- get_h("difference")
  expect_true(h(0)==0)
  
})

test_that("h(0) = -Inf for ratio", {
  h <- get_h("ratio")
  expect_true(h(0)==-Inf)
  
})

test_that("h(0) = -Inf for OR", {
  h <- get_h("oddsratio")
  expect_true(h(0)==-Inf)
  
})

test_that("h(0) = 0 for effcdf", {
   
  h <- get_h("effcdf")
  expect_true(h(0)==0)
  
})

test_that("h(0) = Inf for efflogs", {
  h <- get_h("efflogs")
  expect_true(h(0)==Inf)
  
})

test_that("h(1) = 1 for difference", {
  h <- get_h("difference")
  expect_true(h(1)==1)
  
})

test_that("h(1) = 0 for ratio", {
  h <- get_h("ratio")
  expect_true(h(1)==0)
  
})

test_that("h(1) = Inf for OR", {
  h <- get_h("oddsratio")
  expect_true(h(1)==Inf)
  
})

test_that("h(1) = -Inf for effcdf", {
  h <- get_h("effcdf")
  expect_true(h(1)==-Inf)
  
})

test_that("h(1) = -Inf for efflogs", {
  h <- get_h("efflogs")
  expect_true(h(1)==-Inf)
  
})


test_that("h'(0) = 1 for difference", {
  dh <- get_dh("difference")
  expect_true(dh(0)==1)
  
})

test_that("h'(0) = Inf for ratio", {
  dh <- get_dh("ratio")
  expect_true(dh(0)==Inf)
  
})

test_that("h'(0) = Inf for OR", {
  dh <- get_dh("oddsratio")
  expect_true(dh(0)==Inf)
  
})

test_that("h'(0) = -1 for effcdf", {
  dh <- get_dh("effcdf")
  expect_true(dh(0)==-1)
  
})

test_that("h'(0) = -Inf for efflogs", {
  dh <- get_dh("efflogs")
  expect_true(dh(0)==-Inf)
  
})

test_that("h'(1) = 1 for difference", {
  dh <- get_dh("difference")
  expect_true(dh(1)==1)
  
})

test_that("h'(1) = 1 for ratio", {
  dh <- get_dh("ratio")
  expect_true(dh(1)==1)
  
})

test_that("h'(1) = Inf for OR", {
  dh <- get_dh("oddsratio")
  expect_true(dh(1)==Inf)
  
})

test_that("h'(1) = -Inf for effcdf", {
  dh <- get_dh("effcdf")
  expect_true(dh(1)==-Inf)
  
})

test_that("h'(1) = -inf for efflogs", {
  dh <- get_dh("efflogs")
  expect_true(dh(1)==-Inf)
  
})

test_that("Sigma(0,0) = 0 for diff", {
  dh <- get_dh("difference")
  expect_true(calc_sigma(0,0,dh)==0)
  
})

test_that("Sigma(0,0) = 0 for ratio", {
  dh <- get_dh("ratio")
  expect_true(calc_sigma(0,0,dh)==0)
  
})

test_that("Sigma(0,0) = 0 for OR", {
  dh <- get_dh("oddsratio")
  expect_true(calc_sigma(0,0,dh)==0)
  
})

test_that("Sigma(0,0) = 0 for effcdf", {
  dh <- get_dh("effcdf")
  expect_true(calc_sigma(0,0,dh)==0)
  
})

test_that("Sigma(0,0) = 0 for efflogs", {
  dh <- get_dh("efflogs")
  expect_true(calc_sigma(0,0,dh)==0)
  
})

test_that("Sigma(1,0) = 0 for diff", {
  dh <- get_dh("difference")
  expect_true(calc_sigma(1,0,dh)==0)
  
})

test_that("Sigma(1,0) = 0 for ratio", {
  dh <- get_dh("ratio")
  expect_true(calc_sigma(1,0,dh)==0)
  
})

test_that("Sigma(1,0) = 0 for OR", {
  dh <- get_dh("oddsratio")
  expect_true(calc_sigma(1,0,dh)==0)
  
})

test_that("Sigma(1,0) = 0 for effcdf", {
  dh <- get_dh("effcdf")
  expect_true(calc_sigma(1,0,dh)==0)
  
})

test_that("Sigma(1,0) = 0 for efflogs", {
  dh <- get_dh("efflogs")
  expect_true(calc_sigma(1,0,dh)==0)
  
})

test_that("Sigma(0,V) = V for diff", {
  dh <- get_dh("difference")
  
  Sigmas <- calc_sigma(rep(0,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==seq(0.1,0.9,by=0.1)))
  
})

test_that("Sigma(0,V) = Inf for ratio", {
  dh <- get_dh("ratio")
  
  Sigmas <- calc_sigma(rep(0,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("Sigma(0,V) = Inf for oddsratio", {
  dh <- get_dh("oddsratio")
  
  Sigmas <- calc_sigma(rep(0,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("Sigma(0,V) = V for effcdf", {
  dh <- get_dh("effcdf")
  
  Sigmas <- calc_sigma(rep(0,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==seq(0.1,0.9,by=0.1)))
  
})

test_that("Sigma(0,V) = Inf for efflogs", {
  dh <- get_dh("efflogs")
  
  Sigmas <- calc_sigma(rep(0,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("Sigma(1,V) = V for diff", {
  dh <- get_dh("difference")
  
  Sigmas <- calc_sigma(rep(1,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==seq(0.1,0.9,by=0.1)))
  
})

test_that("Sigma(1,V) = V for ratio", {
  dh <- get_dh("ratio")
  
  Sigmas <- calc_sigma(rep(1,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==seq(0.1,0.9,by=0.1)))
  
})

test_that("Sigma(1,V) = Inf for oddsratio", {
  dh <- get_dh("oddsratio")
  
  Sigmas <- calc_sigma(rep(1,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("Sigma(1,V) = Inf for effcdf", {
  dh <- get_dh("effcdf")
  
  Sigmas <- calc_sigma(rep(1,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("Sigma(1,V) = Inf for efflogs", {
  dh <- get_dh("efflogs")
  
  Sigmas <- calc_sigma(rep(1,9), seq(0.1,0.9,by=0.1), dh)
  
  expect_true(all(Sigmas==Inf))
  
})

test_that("ginv(g(D))=D for difference", {
   
  parm="difference"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g_inv(g(values))==values))
  
})

test_that("g(ginv(beta))=beta for difference", {
   
  parm="difference"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g(g_inv(values))==values))
  
})

test_that("ginv(g(D))=D for ratio", {
   
  parm="ratio"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g_inv(g(values))==values))
  
})

test_that("g(ginv(beta))=beta for ratio", {
   
  parm="ratio"
  values=c(0,0.5,1,0.5,Inf)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g(g_inv(values))==values))
  
})

test_that("ginv(g(D))=D for oddsratio", {
   
  parm="oddsratio"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g_inv(g(values))==values))
  
})

test_that("g(ginv(beta))=beta for oddsratio", {
   
  parm="oddsratio"
  values=c(0,0.5,1,0.5,Inf)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g(g_inv(values))==values))
  
})

test_that("ginv(g(D))=D for effcdf", {
   
  parm="effcdf"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g_inv(g(values))==values))
  
})

test_that("g(ginv(beta))=beta for effcdf", {
   
  parm="effcdf"
  values=c(-Inf,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g(g_inv(values))==values))
  
})


test_that("ginv(g(D))=D for efflogs", {
   
  parm="efflogs"
  values=c(-1,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g_inv(g(values))==values))
  
})

test_that("g(ginv(beta))=beta for efflogs", {
   
  parm="efflogs"
  values=c(-Inf,-0.5,0,0.5,1)
  
  g <- get_g(parm)
  g_inv <- get_ginv(parm)
  
  expect_true(all(g(g_inv(values))==values))
  
})

test_that("CI contains beta estimate, parmtype = difference, standard method with zero-one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
             method="standard", parmtype = "difference", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, regular hybrid method with zero-one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adjusted hybrid method with zero-one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adjusted hybrid method with shrunken KM ", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="sh_adj_hybrid", parmtype = "difference")
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="standard", parmtype = "oddsratio",zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, regular hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="reg_hybrid", parmtype = "oddsratio",zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adjusted hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adjusted hybrid method with shrunken KM", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="sh_adj_hybrid", parmtype = "oddsratio")
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="standard", parmtype = "ratio", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, regular hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adjusted hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adjusted hybrid method with shrunken KM", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="sh_adj_hybrid", parmtype = "ratio")
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with zero-one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="standard", parmtype = "efflogs", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, regular hybrid method with zero-one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adjusted hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adjusted hybrid method with shrunken KM", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="sh_adj_hybrid", parmtype = "efflogs")
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="standard", parmtype = "effcdf", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, regular hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adjusted hybrid method with zero.one adjustment", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment = T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adjusted hybrid method with shrunken KM", {
   
  res <- delta2samp(time=leuk2$time, status=leuk2$status, group=leuk2$treatment,
                    method="sh_adj_hybrid", parmtype = "effcdf")
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

# test extreme cases (and switch group order)

# S1 = s, S2 = 1
test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= s, S2=1", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

# S1 = 0, S2 = 1 

test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 0, S2=1", {
  
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= 0, S2=1", {
  
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= 1, S2=0", {
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})


test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
  
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
  
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

# S1 = s, S2 = 0

test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all((res$lower <= res$beta)[-1]) & all((res$upper >= res$beta)[-1]))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})

test_that("CI contains beta estimate, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$lower <= res$beta) & all(res$upper >= res$beta))
  
})


test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=s", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=1", {
   
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

# S1 = 0, S2 = 1 

test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= 0, S2=1", {
  
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
  
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
  
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
  
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=1", {
   
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 1, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

# S1 = s, S2 = 0

test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, standard method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, reg_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="reg_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = difference, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "difference", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = ratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "ratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
  
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = oddsratio, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "oddsratio", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = effcdf, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "effcdf", zero.one.adjustment=T, changeGroupOrder=T)
  
  
  expect_true(all(res$p.value <= 1) & all(res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= 0, S2=s", {
   
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T)
  
  
  expect_true(all(res$p.value <= 1 & res$p.value >= 0))
  
})

test_that("p-value is between 0 and 1, parmtype = efflogs, sh_adj_hybrid method with 0/1 adjustment, S1= s, S2=0", {
   
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="sh_adj_hybrid", parmtype = "efflogs", zero.one.adjustment=T, changeGroupOrder=T)
  
  expect_true(all(res$p.value <= 1 & res$p.value >= 0))
  
})

test_that("zero.one adjustment, parmtype = difference, standard method, (1,1)", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "difference", zero.one.adjustment=T)
  
  # 1,1 - Type 1, finite limits, expect beta = 0 
  expect_true(res$beta[1]==0)
  
})

test_that("zero.one adjustment, parmtype = ratio, (1,1)", {
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = "ratio", zero.one.adjustment=T)
  
  # 1,1 - Type 1, finite limits, expect beta = 1
  expect_true(res$beta[1]==1)
  
})

test_that("zero.one adjustment, parmtype = oddsratio, (1,1), (1,s), (s,1)", {
  parmtype <- "oddsratio"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # 1,1 - Type 1, infinite limits, expect beta = beq, lower CI = B^, upper CI = Bv
  expect_true(res$beta[1]==beq)
  expect_true(res$lower[1]==blo)
  expect_true(res$upper[1]==bup)
  
  # (1,s) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res$beta[-1]==blo))
  expect_true(all(res$lower[-1]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res$upper[-1]==bup))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,1) - Type III, expect beta = upper limit, and lower CI = upper limit
  expect_true(all(res_reverse$beta[-1]==bup))
  expect_true(all(res_reverse$upper[-1]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res_reverse$lower[-1]==blo))

})

test_that("zero.one adjustment, parmtype = effcdf, (1,1), (1,s), (s,1)", {
  parmtype <- "effcdf"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # 1,1 - Type 1, infinite limits, expect beta = beq, lower CI = B^, upper CI = Bv
  expect_true(res$beta[1]==beq)
  expect_true(res$lower[1]==blo)
  expect_true(res$upper[1]==bup)
  
  # (1,s) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res$beta[-1]==blo))
  expect_true(all(res$lower[-1]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res$upper[-1]==bup))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,1) - Type III, expect beta = upper limit, and lower CI = upper limit
  expect_true(all(res_reverse$beta[-1]==bup))
  expect_true(all(res_reverse$upper[-1]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res_reverse$lower[-1]==blo))
  
})

test_that("zero.one adjustment, parmtype = efflogs, (1,1), (1,s), (s,1)", {
  parmtype <- "efflogs"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # 1,1 - Type 1, infinite limits, expect beta = beq, lower CI = B^, upper CI = Bv
  expect_true(res$beta[1]==beq)
  expect_true(res$lower[1]==blo)
  expect_true(res$upper[1]==bup)
  
  # (1,s) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res$beta[-1]==blo))
  expect_true(all(res$lower[-1]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res$upper[-1]==bup))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure$time, status=d_failure$status, group=d_failure$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,1) - Type III, expect beta = upper limit, and lower CI = upper limit
  expect_true(all(res_reverse$beta[-1]==bup))
  expect_true(all(res_reverse$upper[-1]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res_reverse$lower[-1]==blo))
  
})

test_that("zero.one adjustment, parmtype = ratio, (0,s), (s,0)", {
  parmtype <- "ratio"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (0,s) - Type III, expect beta = upper limit, and upper CI = upper limit
  expect_true(all(res$beta[18:19]==bup))
  expect_true(all(res$upper[18:19]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res$lower[18:19]==blo))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,0) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res_reverse$beta[18:19]==blo))
  expect_true(all(res_reverse$lower[18:19]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res_reverse$upper[18:19]==bup))
  
})

test_that("zero.one adjustment, parmtype = oddsratio, (0,s), (s,0)", {
  parmtype <- "oddsratio"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (0,s) - Type III, expect beta = upper limit, and upper CI = upper limit
  expect_true(all(res$beta[18:19]==bup))
  expect_true(all(res$upper[18:19]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res$lower[18:19]==blo))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,0) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res_reverse$beta[18:19]==blo))
  expect_true(all(res_reverse$lower[18:19]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res_reverse$upper[18:19]==bup))
  
})

test_that("zero.one adjustment, parmtype = efflogs, (0,s), (s,0)", {
  parmtype <- "efflogs"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (0,s) - Type III, expect beta = upper limit, and upper CI = upper limit
  expect_true(all(res$beta[18:19]==bup))
  expect_true(all(res$upper[18:19]==bup))
  
  # lower CI should NOT equal lower limit
  expect_false(all(res$lower[18:19]==blo))
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (s,0) - Type III, expect beta = lower limit, and lower CI = lower limit
  expect_true(all(res_reverse$beta[18:19]==blo))
  expect_true(all(res_reverse$lower[18:19]==blo))
  
  # upper CI should NOT equal upper limit
  expect_false(all(res_reverse$upper[18:19]==bup))
  
})


test_that("zero.one adjustment, parmtype = difference, (0,1), (1,0)", {
  parmtype <- "difference"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (1,0) - Type II, expect beta = lower limit, and lower CI = lower limit
  expect_true(res$beta[19]==blo)
  expect_true(res$lower[19]==blo)
  
  # upper CI should NOT = upper limit
  expect_false(res$upper[19]==bup)
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (0,1) - Type II, expect beta = upper limit, and upper CI = upper limit
  expect_true(res_reverse$beta[19]==bup)
  expect_true(res_reverse$upper[19]==bup)
  
  # lower CI should NOT = lower limit
  expect_false(res_reverse$lower[19]==blo)
  
})

test_that("zero.one adjustment, parmtype = ratio, (0,1), (1,0)", {
  parmtype <- "ratio"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (1,0) - Type II, expect beta = lower limit, and lower CI = lower limit
  expect_true(res$beta[19]==blo)
  expect_true(res$lower[19]==blo)
  
  # upper CI should NOT = upper limit
  expect_false(res$upper[19]==bup)
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (0,1) - Type II, expect beta = upper limit, and upper CI = upper limit
  expect_true(res_reverse$beta[19]==bup)
  expect_true(res_reverse$upper[19]==bup)
  
  # lower CI should NOT = lower limit
  expect_false(res_reverse$lower[19]==blo)
})

test_that("zero.one adjustment, parmtype = oddsratio, (0,1), (1,0)", {
  parmtype <- "oddsratio"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (1,0) - Type II, expect beta = lower limit, and lower CI = lower limit
  expect_true(res$beta[19]==blo)
  expect_true(res$lower[19]==blo)
  
  # upper CI should NOT = upper limit
  expect_false(res$upper[19]==bup)
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (0,1) - Type II, expect beta = upper limit, and upper CI = upper limit
  expect_true(res_reverse$beta[19]==bup)
  expect_true(res_reverse$upper[19]==bup)
  
  # lower CI should NOT = lower limit
  expect_false(res_reverse$lower[19]==blo)
  
})

test_that("zero.one adjustment, parmtype = effcdf, (0,1), (1,0)", {
  parmtype <- "effcdf"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (1,0) - Type II, expect beta = lower limit, and lower CI = lower limit
  expect_true(res$beta[19]==blo)
  expect_true(res$lower[19]==blo)
  
  # upper CI should NOT = upper limit
  expect_false(res$upper[19]==bup)
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (0,1) - Type II, expect beta = upper limit, and upper CI = upper limit
  expect_true(res_reverse$beta[19]==bup)
  expect_true(res_reverse$upper[19]==bup)
  
  # lower CI should NOT = lower limit
  expect_false(res_reverse$lower[19]==blo)
  
})

test_that("zero.one adjustment, parmtype = efflogs, (0,1), (1,0)", {
  parmtype <- "efflogs"
  
  g <- get_g(parmtype)
  h <- get_h(parmtype)
  
  beq <- g(0)
  blo <- g(h(0) - h(1))
  bup <- g(h(1) - h(0))
  
  res <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  # (1,0) - Type II, expect beta = lower limit, and lower CI = lower limit
  expect_true(res$beta[19]==blo)
  expect_true(res$lower[19]==blo)
  
  # upper CI should NOT = upper limit
  expect_false(res$upper[19]==bup)
  
  # now reverse direction
  res_reverse <- delta2samp(time=d_failure_2$time, status=d_failure_2$status, group=d_failure_2$rx,
                            method="standard", parmtype = parmtype, zero.one.adjustment=T, changeGroupOrder = T)
  
  # (0,1) - Type II, expect beta = upper limit, and upper CI = upper limit
  expect_true(res_reverse$beta[19]==bup)
  expect_true(res_reverse$upper[19]==bup)
  
  # lower CI should NOT = lower limit
  expect_false(res_reverse$lower[19]==blo)
  
})

test_that("zero.one adjustment does not affect non 0/1 cases", {
   
  parmtype <- "difference"
  
  res <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=T)
  
  res_noadj <- delta2samp(time=d_failure_3$time, status=d_failure_3$status, group=d_failure_3$rx,
                    method="standard", parmtype = parmtype, zero.one.adjustment=F)
  
  expect_true(all(res$beta[4:17]==res_noadj$beta[4:17]))
  
})

test_that("Test p-value for zero.one adjustment is correct, no censoring, difference, standard",{
  parmtype="difference"
  method="standard"

  # delta2samp result
package_res <- delta2samp(time=c(1,2,12,14,15,1,2,3,4,13),status=rep(1,10),group=c(rep(0,5),rep(1,5)), testtime=10,
                          parmtype=parmtype, method=method,zero.one.adjustment = TRUE)

# result by hand
p0<- 2/5
p1<- 4/5
Za<-qnorm(.975)
SE<-sqrt( p0*(1-p0)/5 + p1*(1-p1)/5 )

Z<- (p1-p0)/SE

expect_equal(package_res$p.value, 2*pnorm(-Z))



})

test_that("Test p-value for zero.one adjustment is correct, no censoring, difference, reg hybrid",{
  parmtype="difference"
  method="reg_hybrid"
  
  # delta2samp result
  package_res <- delta2samp(time=c(1,2,12,14,15,1,2,3,4,13),status=rep(1,10),group=c(rep(0,5),rep(1,5)), testtime=10,
                            parmtype=parmtype, method=method,zero.one.adjustment = TRUE)
  
  # result by hand
  p0<- 2/5
  p1<- 4/5
  Za<-qnorm(.975)
  SE<-sqrt( p0*(1-p0)/5 + p1*(1-p1)/5 )
  
  Z<- (p1-p0)/SE
  
  expect_equal(package_res$p.value, 2*pnorm(-Z))
  
  
  
})

test_that("p-value = 1 for ratio S1=0, S2=0, zero.one adj", {
   
  parmtype="ratio"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=0,n1=12,x2=0,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
    tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})

test_that("p-value = 1 for oddsratio S1=0, S2=0, zero.one adj", {
  parmtype="oddsratio"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=0,n1=12,x2=0,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})

test_that("p-value = 1 for oddsratio S1=1, S2=1, zero.one adj", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=24,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})

test_that("p-value = 1 for efflogs S1=0, S2=0, zero.one adj", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=0,n1=12,x2=0,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})

test_that("p-value = 1 for efflogs S1=1, S2=1, zero.one adj", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=24,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})

test_that("p-value = 1 for effcdf S1=1, S2=1, zero.one adj", {
   
  parmtype="effcdf"
  alt="less"
  z.o=T
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=24,n2=24)
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
  
  alt="greater"
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, testtime=1,conf.level = 0.95,
                    zero.one.adjustment = z.o, method="standard",parmtype=parmtype,alternative =alt,
                    changeGroupOrder =F)
  
  expect_equal(res$p.value,1,
               tolerance=0.001)
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, zero.one adj, standard", {
  parmtype="difference"
  alt="less"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, zero.one adj, reg_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, zero.one adj, adj_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, zero.one adj, sh_adj_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, NO zero.one adj, standard", {
   
  parmtype="difference"
  alt="less"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, NO zero.one adj, reg_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, NO zero.one adj, adj_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, less, NO zero.one adj, sh_adj_hybrid", {
   
  parmtype="difference"
  alt="less"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, zero.one adj, standard", {
   
  parmtype="difference"
  alt="greater"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.2,
    tolerance=0.001)
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, zero.one adj, reg_hybrid", {
   
  parmtype="difference"
  alt="greater"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, zero.one adj, adj_hybrid", {
   
  parmtype="difference"
  alt="greater"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, zero.one adj, sh_adj_hybrid", {
  
  parmtype="difference"
  alt="greater"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, NO zero.one adj, standard", {
  parmtype="difference"
  alt="greater"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, NO zero.one adj, reg_hybrid", {
   
  parmtype="difference"
  alt="greater"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, NO zero.one adj, adj_hybrid", {
   
  parmtype="difference"
  alt="greater"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - difference, greater, NO zero.one adj, sh_adj_hybrid", {
   
  parmtype="difference"
  alt="greater"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.2, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.2,
    tolerance=0.001)
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, zero.one.adjust, standard ", {
   
  parmtype="ratio"
  alt="less"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, zero.one.adjust, reg_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, zero.one.adjust, adj_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, NO zero.one.adjust, standard ", {
   
  parmtype="ratio"
  alt="less"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, less, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="ratio"
  alt="less"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, zero.one.adjust, standard ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, zero.one.adjust, reg_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, zero.one.adjust, adj_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, NO zero.one.adjust, standard ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - ratio, greater, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="ratio"
  alt="greater"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})


test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, zero.one.adjust, standard ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, zero.one.adjust, reg_hybrid ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, zero.one.adjust, adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, NO zero.one.adjust, standard ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, NO zero.one.adjust, adj_hybrid ", {
  
  parmtype="oddsratio"
  alt="less"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, less, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="less"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, zero.one.adjust, standard ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=T
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, zero.one.adjust, reg_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=T
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, zero.one.adjust, adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=T
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=T
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, NO zero.one.adjust, standard ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=F
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=F
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=F
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - oddsratio, greater, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="oddsratio"
  alt="greater"
  z.o=F
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=0.3, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),0.3,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, zero.one.adjust, standard ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=T
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, zero.one.adjust, reg_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, zero.one.adjust, adj_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, NO zero.one.adjust, standard ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=F
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, less, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="effcdf"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, zero.one.adjust, standard ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=T
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, zero.one.adjust, reg_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, zero.one.adjust, adj_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, NO zero.one.adjust, standard ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="standard"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - effcdf, greater, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="effcdf"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, zero.one.adjust, standard ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, zero.one.adjust, reg_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, zero.one.adjust, adj_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=T
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, NO zero.one.adjust, standard ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=F
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, less, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="efflogs"
  alt="less"
  z.o=F
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, zero.one.adjust, standard ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=T
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, zero.one.adjust, reg_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, zero.one.adjust, adj_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=T
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, NO zero.one.adjust, standard ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=F
  null=1-1/0.3
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp"),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, NO zero.one.adjust, reg_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="reg_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, NO zero.one.adjust, adj_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})

test_that("Compatability of p-value and confidence limit (non-extreme data) - efflogs, greater, NO zero.one.adjust, sh_adj_hybrid ", {
   
  parmtype="efflogs"
  alt="greater"
  z.o=F
  null=1-1/0.3
  method="sh_adj_hybrid"
  
  expect_equal(
    pvalue.CI.compatability(x1=3,n1=12,x2=9,n2=24,
                            Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
    tolerance=0.001)
  
  
})



test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, less, zero.one.adjustment, standard)", {
                  
                 
                 parmtype="difference"
                 alt="less"
                 z.o=T
                 method="standard"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.9
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, less, zero.one.adjustment, reg_hybrid)", {
                  
                 
                 parmtype="difference"
                 alt="less"
                 z.o=T
                 method="reg_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.9
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, less, zero.one.adjustment, adj_hybrid)", {
                  
                 
                 parmtype="difference"
                 alt="less"
                 z.o=T
                 method="adj_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.9
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, less, zero.one.adjustment, sh_adj_hybrid)", {
                  
                 
                 parmtype="difference"
                 alt="less"
                 z.o=T
                 method="sh_adj_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.9
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, greater, zero.one.adjustment, standard)", {
                  
                 parmtype="difference"
                 alt="greater"
                 z.o=T
                 method="standard"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.9
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.5
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=-0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001) 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, greater, zero.one.adjustment, reg_hybrid)", {
                  
                 parmtype="difference"
                 alt="greater"
                 z.o=T
                 method="reg_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.9
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.5
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=-0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001) 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, greater, zero.one.adjustment, adj_hybrid)", {
                  
                 parmtype="difference"
                 alt="greater"
                 z.o=T
                 method="adj_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.9
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.5
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=-0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001) 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - difference, greater, zero.one.adjustment, sh_adj_hybrid)", {
                  
                 parmtype="difference"
                 alt="greater"
                 z.o=T
                 method="sh_adj_hybrid"
                 
                 # x1=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.2
                 expect_equal(
                   pvalue.CI.compatability(0,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=0,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.2
                 expect_equal(
                   pvalue.CI.compatability(3,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=-0.9
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x2=n2,  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.5
                 expect_equal(
                   pvalue.CI.compatability(3,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=n1, x2=n2, pick nullparm carefully 
                 null=-0.1
                 expect_equal(
                   pvalue.CI.compatability(12,12,9,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 # x1=0, x2=0, pick nullparm carefully 
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001) 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - ratio, zero.one.adjustment, standard", {
                  
                 parmtype="ratio"
                 z.o=T
                 method="standard"
                 
                 # x1=1, x2=1  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - ratio, zero.one.adjustment, reg_hybrid", {
                  
                 parmtype="ratio"
                 z.o=T
                 method="reg_hybrid"
                 
                 # x1=1, x2=1  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - ratio, zero.one.adjustment, adj_hybrid", {
                 
                 parmtype="ratio"
                 z.o=T
                 method="adj_hybrid"
                 
                 # x1=1, x2=1  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - ratio, zero.one.adjustment, sh_adj_hybrid", {
                  
                 parmtype="ratio"
                 z.o=T
                 method="sh_adj_hybrid"
                 
                 # x1=1, x2=1  cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(12,12,24,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp",method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - effcdf, zero.one.adjustment, standard", {
                  
                 parmtype="effcdf"
                 z.o=T
                 method="standard"
                 
                 # x1=0, x2=0 cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=1-1/0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - effcdf, zero.one.adjustment, reg_hybrid", {
                  
                 parmtype="effcdf"
                 z.o=T
                 method="reg_hybrid"
                 
                 # x1=0, x2=0 cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=1-1/0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - effcdf, zero.one.adjustment, adj_hybrid", {
                  
                 parmtype="effcdf"
                 z.o=T
                 method="adj_hybrid"
                 
                 # x1=0, x2=0 cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=1-1/0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Compatability of p-value and confidence limit 
               (extreme data) - effcdf, zero.one.adjustment, sh_adj_hybrid", {
                  
                 parmtype="effcdf"
                 z.o=T
                 method="sh_adj_hybrid"
                 
                 # x1=0, x2=0 cannot expect good tolerance if 
                 # p-value is too small (very close to 0) or too big (very close to 1)
                 # so pick nullparm to avoid those situations
                 null=1-1/0.75
                 alt="less"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 alt="greater"
                 expect_equal(
                   pvalue.CI.compatability(0,12,0,24,
                                           Parmtype=parmtype,Alternative=alt,Nullparm=null, changeGroupOrder=F, zero.one=z.o,func="delta2samp", method=method),null,
                   tolerance=0.001)
                 
                 
               })

test_that("Less alternative returns small p-value for difference, zero one adj",{
  # With "less" alternative hypothesis, want to see whether Beta < Beta0
  # So if your beta0 is, let's say, equal to 2 for the ratio
  # if S2/S1 is more like 0.5 (S2 < S1), you would expect p-value to be very small
   
  parmtype="difference"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(1)-h(0.5))
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for ratio, zero one adj",{
  # With "greater" alternative hypothesis, want to see whether Beta > Beta0
  # So if your beta0 is, let's say, equal to 0.5 for the ratio
  # if S2/S1 is more like 2 (S2 > S1), you would expect p-value to be very small
   
  parmtype="difference"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(1))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=24, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for difference, NO zero one adj",{
  # With "less" alternative hypothesis, want to see whether Beta < Beta0
  # So if your beta0 is, let's say, equal to 2 for the ratio
  # if S2/S1 is more like 0.5 (S2 < S1), you would expect p-value to be very small
   
  parmtype="difference"
  z.o=F
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(1)-h(0.5))
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for difference, NO zero one adj",{
  # With "greater" alternative hypothesis, want to see whether Beta > Beta0
  # So if your beta0 is, let's say, equal to 0.5 for the ratio
  # if S2/S1 is more like 2 (S2 > S1), you would expect p-value to be very small
   
  parmtype="difference"
  z.o=F
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(1))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=24, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for ratio, zero one adj",{
  # With "less" alternative hypothesis, want to see whether Beta < Beta0
  # So if your beta0 is, let's say, equal to 2 for the ratio
  # if S2/S1 is more like 0.5 (S2 < S1), you would expect p-value to be very small
  
  parmtype="ratio"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(1)-h(0.5))
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
             parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for ratio, zero one adj",{
  # With "greater" alternative hypothesis, want to see whether Beta > Beta0
  # So if your beta0 is, let's say, equal to 0.5 for the ratio
  # if S2/S1 is more like 2 (S2 > S1), you would expect p-value to be very small
   
  parmtype="ratio"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(1))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=24, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for ratio, NO zero one adj",{
  # With "less" alternative hypothesis, want to see whether Beta < Beta0
  # So if your beta0 is, let's say, equal to 2 for the ratio
  # if S2/S1 is more like 0.5 (S2 < S1), you would expect p-value to be very small
   
  parmtype="ratio"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(1)-h(0.5))
  
  df <- create_nocensoring_data(x1=12,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for ratio, NO zero one adj",{
  # With "greater" alternative hypothesis, want to see whether Beta > Beta0
  # So if your beta0 is, let's say, equal to 0.5 for the ratio
  # if S2/S1 is more like 2 (S2 > S1), you would expect p-value to be very small
   
  parmtype="ratio"
  z.o=F
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(1))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=24, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for oddsratio, zero one adj",{
   
  parmtype="oddsratio"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for oddsratio, zero one adj",{
   
  parmtype="oddsratio"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for oddsratio, NO zero one adj",{
   
  parmtype="oddsratio"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for oddsratio, NO zero one adj",{
   
  parmtype="oddsratio"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for effcdf, zero one adj",{
   
  parmtype="effcdf"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for effcdf, zero one adj",{
   
  parmtype="effcdf"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for effcdf, NO zero one adj",{
   
  parmtype="effcdf"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for effcdf, NO zero one adj",{
   
  parmtype="effcdf"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for efflogs, zero one adj",{
   
  parmtype="efflogs"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for efflogs, zero one adj",{
   
  parmtype="efflogs"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Less alternative returns small p-value for efflogs, NO zero one adj",{
   
  parmtype="efflogs"
  z.o=T
  alt="less"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.99)-h(0.5))
  
  df <- create_nocensoring_data(x1=11,n1=12,x2=12, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also small, we expect to fail to reject
  null=g(h(0.5)-h(0.999))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

test_that("Greater alternative returns small p-value for efflogs, NO zero one adj",{
   
  parmtype="efflogs"
  z.o=T
  alt="greater"
  
  h <- get_h(parmtype)
  g <- get_g(parmtype)
  null=g(h(0.5)-h(0.999))
  
  df <- create_nocensoring_data(x1=6,n1=12,x2=23, n2=24)
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value < 0.05)
  
  # and now if null is also large, we expect to fail to reject
  null=g(h(0.999)-h(0.5))
  
  res <- delta2samp(time=df$Time, status=df$Status, group=df$Group, zero.one.adjustment = z.o, 
                    parmtype=parmtype,nullparm = null, alternative = alt, testtime = 1)
  
  expect_true(res$p.value > 0.05)
  
})

