\name{bpcp2samp}
\alias{bpcp2samp}
\alias{delta2samp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Melded BPCP test
}
\description{
Tests for dissimilarity between two groups in their survival distributions at a fixed point in time. Can operationalize that dissimilarity as 'difference', 'ratio' or 
'oddsratio'.
}
\usage{
bpcp2samp(time, status, group, testtime = NULL, parmtype =
                 c("difference", "oddsratio", "ratio", "efflogs",
                 "effcdf", "cdfratio", "logsratio", "one.minus.ratio",
                 "one.minus.cdfratio"), nullparm = NULL, alternative =
                 c("two.sided", "less", "greater"), conf.level = 0.95,
                 midp = FALSE, changeGroupOrder = FALSE, control =
                 bpcp2sampControl(), add.eps = 1e-10)
    
delta2samp(time,status,group, testtime=NULL,conf.level=0.95,
                       zero.one.adjustment=FALSE,
                       method=c("standard","reg_hybrid","adj_hybrid","sh_adj_hybrid"),
                       parmtype=c("difference","oddsratio","ratio","efflogs","effcdf"),
                       nullparm=NULL,
                       alternative=c("two.sided","less","greater"),
                       changeGroupOrder=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{time}{
time to event for each observation
}
  \item{status}{
status of event time, 1 is observed, 0 is right censored
}
  \item{group}{
group for test, should have two levels, to change order use as factor and change order of levels
}
  \item{testtime}{
vector of fixed times to test between the two survival distributions,  default of NULL will return results for all distinct times in the data
}
  \item{parmtype}{
parameter type for comparing the survival function of the two groups, either 'difference' 'ratio' 'oddsratio' 'cdfratio' 'effcdf' 'efflogs' 'one.minus.ratio' or 'one.minus.cdfratio' (see details)
}
  \item{nullparm}{
null value of the parameter of interest, default of NULL gives 0 if parmtype='difference' and 1 otherwise
}
  \item{alternative}{
character, either 'two.sided','less', or 'greater' 
}
  \item{conf.level}{
confidence level, e.g., 0.95
}
\item{midp}{logical, do mid-p tests and confidence intervals?}
\item{changeGroupOrder}{logical, change the order of the groups?}
  \item{control}{
list of control parameters, see \code{\link{bpcp2sampControl}}
}
  \item{add.eps}{
numeric value to add onto censored observations, default is 1e-10
}
\item{zero.one.adjustment}{default=FALSE, if true performs ad hoc modifications to the delta method when Kaplan-Meier estimators are 0 or 1.}
\item{method}{the delta method for constructing estimates and confidence intervals. 
`standard` uses the KM estimate and greenwood variance; 
'reg_hybrid' uses the KM estimate and Borkowf's regular hybrid variance; 
'adj_hybrid' uses the KM estimate and Borkowf's adjusted hybrid variance; and 
'sh_adj_hybrid' uses a shrunken KM estimate and Borkowf's adjusted hybrid variance}
}
\details{
There are two main functions for two-sample testing, bpcp2samp, which gives melded confidence intervals, and delta2samp, which gives confidence intervals based on the delta method and Borkowf's modifications to it.

The melded confidence interval method is a very general procedure to create confidence intervals for the two sample tests by combining one sample confidence intervals. If S1 and S2 are the survival value at \code{testtime} from sample 1 (first value of \code{group}) and sample 2 (second value of \code{group}) respectively, then 
we can get confidence intervals on the S2-S1 (\code{parmtype='difference'}), S2/S1 (\code{parmtype='ratio'}), 
(S2*(1-S1))/(S1*(1-S2)) (\code{parmtype='oddsratio'}), (1-S1))/(1-S2)=F1/F2 (\code{parmtype='cdfratio'}),  1-S2/S1 (\code{parmtype='one.minus.ratio'}), 
or 1-(1-S1))/(1-S2)=1-F1/F2(\code{parmtype='one.minus.cdfratio'}). Some parmtypes 
may return estimates that are \code{NA} (see note).

The resulting melded CIs appear to guarantee coverage as long as the one sample confidence intervals from which the melded CIs are derived have guaranteed coverage themselves. So since we use the BPCP for the one sample intervals and they appear to guarantee coverage (see Fay, Brittain, and Proschan, 2013), we expect the melded BPCP intervals to have at least nominal coverage. Note that when there is no censoring the melded CIs derived from the one-sample BPCPs, give matching inferences to Fisher's exact test (i.e., give theoretically identical p-values) when testing the null hypothesis of equality (S1=S2).  For details see Fay, Proschan and Brittain (2015).   

The original melded CIs focused on combining one sample CIs that that guarantee coverage. We can apply the melding to other CIs as well, such as the mid-p style CIs. The mid-p CIs are not designed to guarantee coverage, but are designed to have close to the nominal coverage 'on average' over all the possible values of the parameters. The usual p-value is derived from Pr[ see observed data or more extreme under null], while the mid p-value version comes from (1/2) Pr[see obs data] + Pr[ see more extreme data]. Mid-p CIs come from inverting the test that uses the mid p-value instead of the usual p-value. 

The delta methods create confidence intervals for two sample tests by combining one-sample estimates for survival and variance, either using the Greenwood variance (method="standard"), or by
substituting the Greenwood variance for ones developed by Borkowf (2005) which have been shown by simulation to be less biased than Greenwood. The zero.one modifications give more
reasonable intervals when the Kaplan-Meier estimate of either of the groups is 0 or 1. Unlike the melded BPCP method, we have shown the delta methods to have coverage less than nominal in some situations.

For backwards compatibility we continue to allow the \code{parmtype="one.minus.cdfratio"}, but it is the same as \code{parmtype="effcdf"}. Additionally, \code{parmtype="one.minus.ratio"} is not an option for \code{delta2samp}.

Due to the assumption that censoring occurs after events in cases where there are ties, we have an add.eps option that will add a pseudo-increase to all censored observations for accurate p-values and confidence intervals at a given testtime. 

}
\value{
The functions return an object of class either "htest" if testtime is NULL, otherwise they will return an object of class "twosamp""

A list with class "htest" contains the following components:
\item{statistic}{estimate of S1, survival at testtime for group 1}
\item{parameter}{estimate of S2, survival at testtime for group 2}
\item{p.value}{p-value for the test}
\item{conf.int}{a confidence interval for the parameter determined by \code{parmtype}}
\item{estimate}{estimate of parameter determined by \code{parmtype} (see note)}
\item{null.value}{the specificed null hypothesized value of the parameter determined by \code{parmtype}}
\item{alternative}{type of alternative with respect to the null.value, either 'two.sided', 'greater' or 'less'}
\item{method}{a character string describing the test}
\item{data.name}{a character string describing the parameter determined by \code{parmtype}}

A list with class "twosamp" contains the following components:
\item{L}{left endpoint of interval}
\item{Lin}{logical vector, include left endpoint?}
\item{R}{right endpoint of interval}
\item{Rin}{logical vector, include right endpoint?}
\item{interval}{interval of survival and confidence interval as determined by \code{L}, \code{Lin}, \code{R}, \code{Rin}}
\item{g1}{name of group 1 as determined by \code{group}}
\item{est_group1}{one-sample survival estimate for group 1 in interval/at time point}
\item{lower_group1}{one-sample lower pointwise confidence limit for group 1 in interval/at time point}
\item{upper_group1}{one-sample upper pointwise confidence limit for group 1 in interval/at time point}
\item{g2}{name of group 2 as determined by \code{group}}
\item{est_group2}{one-sample survival estimate for group 2 in interval/at time point}
\item{lower_group2}{one-sample lower pointwise confidence limit for group 2 in interval/at time point}
\item{upper_group2}{one-sample upper pointwise confidence limit for group 2 in interval/at time point}
\item{beta}{estimate of parameter determined by \code{parmtype} (see note)}
\item{lower}{the lower limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{upper}{the upper limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{conf.level}{confidence level}
\item{p.value}{p-value for the test}
\item{null.value}{the specificed null hypothesized value of the parameter determined by \code{parmtype}}
\item{alternative}{type of alternative with respect to the null.value, either 'two.sided', 'greater' or 'less'}
\item{method}{a character string describing the test}

                 
}
\references{
Borkowf, C. B. (2005). A simple hybrid variance estimator for the Kaplan-Meier survival function. Statistics in Medicine 24, 827-851.

Fay, MP, Brittain, E, and Proschan, MA. (2013). Pointwise Confidence Intervals for a Survival Distribution with Small Samples or Heavy Censoring.  Biostatistics 14(4): 723-736
doi: 10.1093/biostatistics/kxt016. (copy available at http://www.niaid.nih.gov/about/organization/dcr/brb/staff/Pages/michael.aspx).  

Fay, MP, Proschan, MA, and Brittain, E (2015) Combining One Sample Confidence Procedures for Inferences in the Two Sample Case. Biometrics 71:146-156. 


}
\note{
When \code{parmtype='ratio'} and both S1=S2=0, then since 0/0 is undefined, the estimate 
is set to NA. This makes sense because if the true value of S1 and S2 are extremely
small, then it is very likely we will observe S1=0 and S2=0; however, extremely 
different ratios can both give a high probability of observing S1=S2=0.
For example,  0.001/0.00001=100  and 0.00001/0.001 = 1/100 give very extreme 
and opposite estimates. For similar reasons, \code{parmtype='oddsratio'} gives
NA for S1=S2=0 or S1=S2=1, \code{parmtype='cdfratio'} gives NA for S1=S2=1,  
\code{parmtype='one.minus.ratio'} gives NA for S1=S2=0, 
and \code{parmtype='one.minus.cdfratio'} gives NA for S1=S2=1.

}
\author{
Michael P. Fay
}
\examples{
data(leuk2)
# test difference of S(20) values
# S(20)=survival function at 20 weeks 
bpcp2samp(leuk2$time,leuk2$status,leuk2$treatment,
   20,parmtype="difference")
# test ratio of S(20) in two treatment groups, 
bpcp2samp(leuk2$time,leuk2$status,leuk2$treatment,
   20,parmtype="ratio")
# change the order of the group variable to get the other ratio 
bpcp2samp(leuk2$time,leuk2$status,leuk2$treatment,20,
   parmtype="ratio",changeGroupOrder=TRUE)
# estimate treatment effect= 1 - F(20,trt)/F(20,plac), 
#   where F(20)=1-S(20) = Pr(T <=20) is the 
#   cumulative distribution function 
# Test whether treatment effect is greater than 30 pct
bpcp2samp(leuk2$time,leuk2$status,leuk2$treatment,20,
    parmtype="one.minus.cdfratio",nullparm=0.30,
    alternative="greater",
    changeGroupOrder=FALSE)

# Output estimates and CIs for all intervals within the data
bpcp2samp(leuk2$time,leuk2$status,leuk2$treatment,testtime=NULL)

# Test delta method using Greenwood variance estimator and zero-one adjustment
delta2samp(leuk2$time,leuk2$status,leuk2$treatment,20,method="standard", zero.one.adjustment=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{htest}
\keyword{twosamp}
\keyword{survival}% __ONLY ONE__ keyword per line
