% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{selected.boostrq}
\alias{selected.boostrq}
\title{Extract indices of selected base learners}
\usage{
\method{selected}{boostrq}(object, ...)
}
\arguments{
\item{object}{a boostrq object}

\item{...}{additional arguments passed to callies}
}
\value{
an index vector indicating the selected base learner in each iteration
}
\description{
Extract indices of selected base learners
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

selected(boosted.rq)

}
