% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyModels.R
\name{WAM}
\alias{WAM}
\title{Linear programming model for Weighted Additive Model}
\usage{
WAM(
  data,
  x,
  y,
  dataOriginal = data,
  xOriginal = x,
  yOriginal = y,
  FDH = FALSE,
  weights
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the new variables
in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{dataOriginal}{\code{data.frame} or \code{matrix} containing the
original
variables used to create the model.}

\item{xOriginal}{Vector. Column input indexes in original data.}

\item{yOriginal}{Vector. Column output indexes in original data.}

\item{FDH}{Binary decision variables}

\item{weights}{Weights. Valid values are: \code{MIP} (Measure of Inefficiency
Proportions), \code{RAM} (Range Adjusted Measure), \code{BAM} (Bounded
Adjusted Measure), \code{normalized} (normalized weighted additive model)
and a user specific vector of the same length as the number of input and
output variables}
}
\value{
\code{matrix} with the the predicted score
}
\description{
This function predicts the expected output through a DEA model.
}
