% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{ca_col_contrib}
\alias{ca_col_contrib}
\title{Compute col contributions}
\usage{
ca_col_contrib(col_coords, X, eigs)
}
\arguments{
\item{col_coords}{col coordinates}

\item{X}{standardized matrix}

\item{eigs}{eigs computed by \code{ca_weighted_eigen}}
}
\value{
A dataframe of col contributions.
}
\description{
Return col contributions for each correspondence component
}
\examples{
library(booklet)

X_scaled <- mtcars[, c(2, 8:11)] |>
  ca_standardize()

eigs <- X_scaled |>
  ca_weighted_eigen()

eigs |>
  ca_col_coords() |>
  ca_col_contrib(X_scaled, eigs) |>
  head()
}
