% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ig.R
\name{InverseGaussian}
\alias{InverseGaussian}
\title{Inverse Gaussian distribution}
\description{
A R6 class to represent an inverse Gaussian distribution.
}
\details{
See \href{https://en.wikipedia.org/wiki/Inverse_Gaussian_distribution}{Wikipedia}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mu}}{Get or set the value of \code{mu}.}

\item{\code{lambda}}{Get or set the value of \code{lambda}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InverseGaussian-new}{\code{InverseGaussian$new()}}
\item \href{#method-InverseGaussian-d}{\code{InverseGaussian$d()}}
\item \href{#method-InverseGaussian-p}{\code{InverseGaussian$p()}}
\item \href{#method-InverseGaussian-q}{\code{InverseGaussian$q()}}
\item \href{#method-InverseGaussian-r}{\code{InverseGaussian$r()}}
\item \href{#method-InverseGaussian-mean}{\code{InverseGaussian$mean()}}
\item \href{#method-InverseGaussian-median}{\code{InverseGaussian$median()}}
\item \href{#method-InverseGaussian-mode}{\code{InverseGaussian$mode()}}
\item \href{#method-InverseGaussian-sd}{\code{InverseGaussian$sd()}}
\item \href{#method-InverseGaussian-variance}{\code{InverseGaussian$variance()}}
\item \href{#method-InverseGaussian-skewness}{\code{InverseGaussian$skewness()}}
\item \href{#method-InverseGaussian-kurtosis}{\code{InverseGaussian$kurtosis()}}
\item \href{#method-InverseGaussian-kurtosisExcess}{\code{InverseGaussian$kurtosisExcess()}}
\item \href{#method-InverseGaussian-clone}{\code{InverseGaussian$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-new"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-new}{}}}
\subsection{Method \code{new()}}{
New inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$new(mu, lambda)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mu}}{parameter, the mean, \code{>0}}

\item{\code{lambda}}{shape parameter, \code{>0}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{inverseGaussian} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-d"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-d}{}}}
\subsection{Method \code{d()}}{
Density function of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$d(x, log = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector of positive numbers}

\item{\code{log}}{Boolean, whether to return the logarithm of the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density or the log-density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-p"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the inverse Gaussian
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-q"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-r"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-mean"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-median"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-median}{}}}
\subsection{Method \code{median()}}{
Median of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$median()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The median of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-mode"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-sd"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-variance"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the inverse Gaussian distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the inverse Gaussian distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGaussian-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGaussian-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGaussian$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
