% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_process.R
\name{zi_inar_process}
\alias{zi_inar_process}
\title{Generate a ZI-INAR Process}
\usage{
zi_inar_process(n, p, alpha, Y = 1, p2, lamb)
}
\arguments{
\item{n}{A positive integer; the length of the simulated process.}

\item{p}{A positive integer; the order of the simulated process.}

\item{alpha}{A numeric vector whose components belong to the interval \eqn{(0,1)};
parameters of the thinning operator (see details below).}

\item{Y}{A non-negative integer; the initial value of the process.}

\item{p2}{A numeric value between \eqn{0} and \eqn{1}; parameter
of the Bernoulli distribution (see details below).}

\item{lamb}{A positive numeric value; parameter of the Poisson distribution (see details below).}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Simulates a zero-inflated Poisson distributed (ZI)-INAR(p) process.
}
\details{
The ZI-INAR process is defined by the equation
\deqn{Y_t=\sum_{i=1}^p \alpha_i\circ Y_{t-i} +V_t, \qquad t\in \mathbb{Z},}
where the so called thinning operator is defined as \deqn{\alpha\circ Y=\sum_{i=1}^Y Z_i,}
where \eqn{\{Z_i\}_{i\in \mathcal{Z}}} is an i.i.d. sequence of random
variables with Bernoulli distribution with parameter \eqn{\alpha} with
\eqn{\alpha_i\in[0,1]} for \eqn{i\in 1,\dots,p} and
independent of \eqn{Y}. Additionally, \eqn{\{V_t\}_{t\in \mathcal{Z}}}
is an i.i.d. non-negative and integer valued sequence of random variables.

Let \eqn{V} be a non-negative discrete random variable with parameters
\eqn{p2} and \eqn{\lambda}. We said that \eqn{V} follows a zero-inflated
distribution and we denote it by \eqn{V\sim ZI(p2,\lambda)}, if it can be expressed as
\deqn{V=BU,\qquad \text{with }\qquad B \perp U,}
where \eqn{B} has Bernoulli distribution with mean \eqn{1-p2},
for \eqn{p2\in[0,1)}
and \eqn{U} is a non-negative discrete valued random
variable with finite variance and parameter vector \eqn{\lambda}.
We consider the zero-inflated Poisson distribution (ZI-INAR(\eqn{p}))),
when \eqn{U} has Poisson distribution with mean \eqn{\lambda}.
}
\examples{
X = zi_inar_process(70, 2, c(0.1,0.1), Y = 1, p2 = 0.2, lamb = 0.7)
plot(X, type="l")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P., Medina-Garay, A., De Lima-Medina, F. and Jales, I. (2024). A
maximum likelihood and regenerative bootstrap approach for estimation and
forecasting of inar (p) processes with zero-inated innovations. \emph{Statistics},
\bold{58}, 336-363.
}
\seealso{
\code{\link{regenboot}}, \code{\link{genETARCH}}, \code{\link{genMM1}}.
}
\keyword{"Integer}
\keyword{"ZI-INAR}
\keyword{"Zero-inflated"}
\keyword{autoregressive}
\keyword{generation"}
\keyword{process}
\keyword{process"}
