% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_outliers.R
\name{find_outliers}
\alias{find_outliers}
\title{Detect additive outliers in weekly time series}
\usage{
find_outliers(
  x,
  dates,
  out.tolerance = 3.8,
  my.AO.list = NULL,
  H = NULL,
  my.k_l = NULL,
  method = "additive"
)
}
\arguments{
\item{x}{Numeric vector containing the observed weekly time series.}

\item{dates}{A vector of class \code{"Date"} corresponding to the observation dates.}

\item{out.tolerance}{Numeric. Absolute t-statistic threshold used for AO inclusion.
Defaults to \code{3.8}.}

\item{my.AO.list}{Optional vector of class \code{"Date"} specifying pre-defined AO dates.
These dates are included in the regression and excluded from the forward search.}

\item{H}{Optional matrix of holiday and trading-day regressors with
\code{nrow(H) = length(x)}.}

\item{my.k_l}{Optional numeric vector of length two specifying the number of yearly and
monthly Fourier harmonics \code{c(k, l)}. If \code{NULL}, \code{my.k_l} is selected
automatically by AICc.}

\item{method}{Character string specifying the decomposition type. Either
\code{"additive"} or \code{"multiplicative"}. If \code{"multiplicative"},
the series is log-transformed prior to detrending. Defaults to \code{"additive"}.}
}
\value{
A list with the following components:
\describe{
\item{ao}{Vector of class \code{"Date"} containing detected additive outlier dates,
or \code{NULL} if none are detected.}
\item{my.k_l}{Numeric vector \code{c(k, l)} giving the number of yearly and monthly
Fourier terms used in the regression.}
}
}
\description{
Detects additive outliers (AOs) using a regression-based t-statistic search
procedure following Findley et al. (1998). The function operates on a
detrended series, where the trend is estimated using \code{\link[stats]{supsmu}}.
Optional holiday and trading-day regressors can be included. If the number of
Fourier (trigonometric) terms is not supplied via \code{my.k_l}, it is selected
automatically by minimizing AICc over a grid of yearly and monthly Fourier terms.
}
\examples{

\donttest{
#Not run:
# Searching for additive outliers in Gasoline data
data(gasoline.data)
ao_list=find_outliers(x=gasoline.data$y,dates = gasoline.data$date)}

}
\references{
Findley, D.F., Monsell, B.C., Bell, W.R., Otto, M.C. and Chen, B.C. (1998).
New capabilities and methods of the X-12-ARIMA seasonal-adjustment program.
\emph{Journal of Business and Economic Statistics}, 16(2), 127--152.
}
