\name{graph generation utilities}
\alias{graph generation utilities}
\alias{empty.graph}
\alias{complete.graph}
\alias{random.graph}
\title{Generate empty, complete or random graphs}
\description{
  Generate empty, complete or random directed acyclic graphs from a given set
  of nodes.
}
\usage{
empty.graph(nodes, num = 1)
complete.graph(nodes, num = 1)
random.graph(nodes, num = 1, method = "ordered", ..., debug = FALSE)
}
\arguments{
  \item{nodes}{a vector of character strings, the labels of the nodes.}
  \item{num}{an integer, the number of graphs to be generated.}
  \item{method}{a character string, the label of a score. Possible values are
    \code{ordered} (\emph{full ordering} based generation), \code{ic-dag}
    (Ide's and Cozman's \emph{Generating Multi-connected DAGs} algorithm) and
    \code{melancon} (Melancon's and Philippe's \emph{Uniform Random Acyclic
    Digraphs} algorithm).}
  \item{\dots}{additional tuning parameters (see below).}
  \item{debug}{a boolean value. If \code{TRUE} a lot of debugging output is
    printed; otherwise the function is completely silent. Ignored in some
    generation methods.}
}
\details{

  Graph generation algorithms available in \code{random.graph()} are:

  \itemize{

    \item \emph{full ordering} based generation (\code{ordered}): generates
      graphs whose node ordering is given by the order of the labels in the
      \code{nodes} argument. The same algorithm is used in the
      \code{randomDAG} function in package \pkg{pcalg}.
    \item Ide's and Cozman's \emph{Generating Multi-connected DAGs} algorithm
      (\code{ic-dag}): generates graphs with a uniform probability
      distribution over the set of multiconnected graphs.
    \item Melancon's and Philippe's \emph{Uniform Random Acyclic Digraphs}
      algorithm (\code{melancon}): generates graphs with a uniform probability
      distribution over the set of all possible graphs.

  }

  Additional arguments for the \code{random.graph()} function are:

  \itemize{
    \item \code{prob}: the probability of each arc to be present in a graph
      generated by the \code{ordered} algorithm. The default value is
      \code{2 / (length(nodes) - 1)}, which results in a sparse graph (the
      number of arcs should be of the same order as the number of nodes).
    \item \code{burn.in}: the number of iterations for the \code{ic-dag} and
      \code{melancon} algorithms to converge to a stationary (and uniform)
      probability distribution. The default value is \code{6 * length(nodes)^2}.
    \item \code{every}: return only one graph \code{every} number of steps
      instead of all the graphs generated with \code{ic-dag} and
      \code{melancon}. Since both algorithms are based on Markov Chain Monte
      Carlo approaches, high values of \code{every} result in a more diverse
      set of networks. The default value is \code{1}, i.e. to return all the
      networks that are generated.
    \item \code{max.degree}: the maximum degree for any node in a graph
      generated by the \code{ic-dag} and \code{melancon} algorithms. The default
      value is \code{Inf}.
    \item \code{max.in.degree}: the maximum in-degree for any node in a graph
      generated by the \code{ic-dag} and \code{melancon} algorithms. The default
      value is \code{Inf}.
    \item \code{max.out.degree}: the maximum out-degree for any node in a graph
      generated by the \code{ic-dag} and \code{melancon} algorithms. The default
      value is \code{Inf}.

  }

  \code{empty.graph()} generates \code{num} identical empty graphs, while
  \code{complete.graph()} generates \code{num} identical complete directed
  acyclic graphs.

}
\value{

  \code{empty.graph()}, \code{complete.graph()} and \code{random[.graph()}
  return an object of class \code{bn} (if \code{num} is equal to \code{1}) or a
  list of objects of class \code{bn} (otherwise). If \code{every} is greated
  than \code{1}, \code{random.graph()} always returns a list, regardless of the
  number of graphs it contains.

}
\references{

  Ide JS, Cozman FG (2002). "Random Generation of Bayesian Networks."
    \emph{Proceedings of the 16th Brazilian Symposium on Artificial
    Intelligence}, 366--375.

  Melancon G, Dutour I, Bousquet-Melou M (2001). "Random Generation of Directed
    Acyclic Graphs." \emph{Electronic Notes in Discrete Mathematics},
    \strong{10}:202--207.

  Melancon G, Philippe F (2004). "Generating Connected Acyclic Digraphs
    Uniformly at Random." \emph{Information Processing Letters},
    \strong{90}(4):209--213.

}
\examples{
empty.graph(LETTERS[1:8])
random.graph(LETTERS[1:8])
plot(random.graph(LETTERS[1:8], method = "ic-dag", max.in.degree = 2))
plot(random.graph(LETTERS[1:8]))
plot(random.graph(LETTERS[1:8], prob = 0.2))
}
\author{Marco Scutari}
\keyword{simulation}
