% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-pairwise.R
\name{pairwise.BMSC}
\alias{pairwise.BMSC}
\title{Pairwise contrasts}
\usage{
pairwise.BMSC(mdl, contrast, covariate = NULL, who = "delta")
}
\arguments{
\item{mdl}{An object of class \code{BMSC}.}

\item{contrast}{Character value giving the name of the coefficient whose levels need to be compared.}

\item{covariate}{at the moment is silent}

\item{who}{parameter to choose the estimates to contrast
\describe{
        \item{control}{only the controls}
        \item{singlecase}{only the single case \eqn{(\beta + \delta)}}
        \item{delta}{only the difference between the single case and controls}
}}
}
\value{
a \code{pairwise.BMSC} object
}
\description{
Calculate pairwise comparisons between marginal posterior distributions divided by group levels
}
\examples{
 \donttest{

######################################
# simulation of controls' group data
######################################

# Number of levels for each condition and trials
NCond1  <- 2
NCond2  <- 2
Ntrials <- 8
NSubjs  <- 30

betas <- c( 0 , 0 , 0 ,  0.2)

data.sim <- expand.grid(
  trial      = 1:Ntrials,
  ID         = factor(1:NSubjs),
  Cond1      = factor(1:NCond1),
  Cond2      = factor(1:NCond2)
)

contrasts(data.sim$Cond1) <- contr.sum(2)
contrasts(data.sim$Cond2) <- contr.sum(2)

### d.v. generation
y <- rep( times = nrow(data.sim) , NA )

# cheap simulation of individual random intercepts
set.seed(1)
rsubj <- rnorm(NSubjs , sd = 0.1)

for( i in 1:length( levels( data.sim$ID ) ) ){

  sel <- which( data.sim$ID == as.character(i) )

  mm  <- model.matrix(~ Cond1 * Cond2 , data = data.sim[ sel , ] )

  set.seed(1 + i)
  y[sel] <- mm \%*\% as.matrix(betas + rsubj[i]) +
    rnorm( n = Ntrials * NCond1 * NCond2 )

}

data.sim$y <- y

# just checking the simulated data...
boxplot(y~Cond1*Cond2, data = data.sim)

######################################
# simulation of patient data
######################################

betas.pt <- c( 0 , 0.8 , 0 ,  0)

data.pt <- expand.grid(
  trial      = 1:Ntrials,
  Cond1      = factor(1:NCond1),
  Cond2      = factor(1:NCond2)
)

contrasts(data.pt$Cond1) <- contr.sum(2)
contrasts(data.pt$Cond2) <- contr.sum(2)

### d.v. generation
mm  <- model.matrix(~ Cond1 * Cond2 , data = data.pt )

set.seed(5)
data.pt$y <- (mm \%*\% as.matrix(betas.pt) +
                rnorm( n = Ntrials * NCond1 * NCond2 ))[,1]

# just checking the simulated data...
boxplot(y~Cond1*Cond2, data = data.pt)

mdl <- BMSC(y ~ Cond1 * Cond2 + ( 1 | ID ),
            data_ctrl = data.sim, data_sc = data.pt, seed = 77,
            typeprior = "cauchy", s = 1)

summary(mdl)

pp_check(mdl)


pairwise.BMSC( mdl, contrast = "Cond11:Cond21")

}

}
