% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bls_request.R
\name{bls_request}
\alias{bls_request}
\title{Retrieve Data From the U.S. Bureau Of Labor Statistics API v2}
\usage{
bls_request(
  query,
  api_key = bls_get_key(),
  user_agent = "http://github.com/groditi/blsR",
  process_response = .process_response,
  ...
)
}
\arguments{
\item{query}{list generated by one of the query generating functions}

\item{api_key}{Optional. An API key string. Defaults to the value returned by
\code{\link[=bls_get_key]{bls_get_key()}}. The preferred way to provide an API key is to use
\code{\link[=bls_set_key]{bls_set_key()}} or the \code{BLS_API_KEY} environment variable. Manually passing
the key will be deprecated in future releases.}

\item{user_agent}{string, optional}

\item{process_response}{function, optional. processes the \code{httr} response
object. The default function will return the JSON payload parsed into a list}

\item{...}{further arguments will be passed to \code{process_response} when called}
}
\value{
a list of information returned by the API request
}
\description{
\code{bls_request()}  will execute queries against the BLS API. Queries are
generated using one of the following query-generating functions:
\code{\link[=query_series]{query_series()}}, \code{\link[=query_n_series]{query_n_series()}}, \code{\link[=query_popular_series]{query_popular_series()}},
\code{\link[=query_all_surveys]{query_all_surveys()}}, \code{\link[=query_survey_info]{query_survey_info()}}, \code{\link[=query_latest_observation]{query_latest_observation()}}.
The result is the "Results" block as defined in the API v2 signatures at
\url{https://www.bls.gov/developers/api_signature_v2.htm}
}
\examples{
\dontrun{
library(blsR)
uer_query <- query_series('LNS14000000') #monthly unemployment rate series
uer_results <- bls_request(uer_query) #API response
}
}
\seealso{
Other blsR-requests: 
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_series_request}()}
}
\concept{blsR-requests}
