% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOLS.R
\name{MOLS}
\alias{MOLS}
\title{Prime power MOLS from finite fields}
\usage{
MOLS(p, q, r = 1)
}
\arguments{
\item{p}{is any suitable integer base}

\item{q}{is any suitable integer exponent}

\item{r}{is any suitable number of squares}
}
\value{
Data frame of factor levels for rows, columns and treatment sets
}
\description{
Constructs r sets of mutually orthogonal Latin squares (MOLS) of dimension p**q for prime p and
integer power q where r < p**q. Memory issues mean that the maximum size of the exponent q for 
specific p is restricted to the values shown in the table below:

   \tabular{rrrrrrrr}{
   \bold{prime p} \tab                                       \bold{maximum q}\cr
   2 \tab                                                                13\cr
   3 \tab                                                                 8\cr
   5 \tab                                                                 6\cr                                                      
   7 \tab                                                                 5\cr
   11 \tab                                                                4\cr
   13 17 19 23 \tab                                                       3\cr
   29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 \tab                   2\cr
   Any prime >97 \tab                                                     1
   }
}
\details{
Generates MOLS by cyclic permutation of a basic Latin square constructed from a vector
of ordered elements of a prime-power finite field of size p**q (see Chapter 1 of Raghavarao 1971).

The primitive polynomials for the MOLS generated by this package were
extracted from the Table of Primitive Polynomials given in the Supplement to Hansen and Mullen (1992).

The output is a single data frame of size \eqn{p**q x (r+2)} for the required set of MOLS
with a column for the rows classification, a column for the columns classification and 
separate columns for each treatment set of the required set of squares.

Also see the function \code{GraecoLatin} which will generate pairs of MOLS for a range of 
non-prime power design sizes v**2 including
all odd values of v and any even valued v <= 30 except for 6 or 2.
}
\examples{
MOLS(2,3,7) # Seven MOLS of size 8 x 8
MOLS(3,2,4) # Four MOLS of size 9 x 9
\donttest{MOLS(3,3,4)} # Four MOLS of size 27 x 27
\donttest{MOLS(23,2,2)} # Two MOLS of size 529 x 529
 
}
\references{
Hansen, T. & Mullen, G. L. (1992) Primitive polynomials over finite fields,
Mathematics of Computation, 59, 639-643 and Supplement.

Raghavarao D. (1971) Constructions and Combinatorial Problems in Design of Experiments,
Dover Publications, Inc. Section 1.3
}
\seealso{
\code{\link{GraecoLatin}}
}
