% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birdnet_interface.R
\name{birdnet_model_load}
\alias{birdnet_model_load}
\alias{birdnet_model_tflite}
\alias{birdnet_model_custom}
\alias{birdnet_model_meta}
\alias{birdnet_model_protobuf}
\title{Initialize a BirdNET Model}
\usage{
birdnet_model_tflite(
  version = "v2.4",
  language = "en_us",
  tflite_num_threads = NULL
)

birdnet_model_custom(
  version = "v2.4",
  classifier_folder,
  classifier_name,
  tflite_num_threads = NULL
)

birdnet_model_meta(
  version = "v2.4",
  language = "en_us",
  tflite_num_threads = NULL
)

birdnet_model_protobuf(
  version = "v2.4",
  language = "en_us",
  custom_device = NULL
)
}
\arguments{
\item{version}{character. The version of BirdNET to use (default is "v2.4", no other versions are currently supported).}

\item{language}{character. Specifies the language code to use for the model's text processing. The language must be one of the available languages supported by the BirdNET model.}

\item{tflite_num_threads}{integer. The number of threads to use for TensorFlow Lite operations. If NULL (default), the default threading behavior will be used.
Will be coerced to an integer if possible.}

\item{classifier_folder}{character. Path to the folder containing the custom classifier.}

\item{classifier_name}{character. Name of the custom classifier.}

\item{custom_device}{character. This parameter allows specifying a custom device on which computations should be performed.
If \code{custom_device} is not specified (i.e., it has the default value None), the program will attempt to use a GPU (e.g., "/device:GPU:0") by default.
If no GPU is available, it will fall back to using the CPU. By specifying a device string such as "/device:GPU:0" or "/device:CPU:0", the user can explicitly choose the device on which operations should be executed.}
}
\value{
A BirdNET model object, which is an S3 object of class \code{birdnet_model} and specific subclasses (e.g., \code{birdnet_model_tflite}, \code{birdnet_model_v2_4}). This object is a list containing:
\describe{
\item{\code{py_model}}{The underlying Python BirdNET model object.}
\item{\code{model_version}}{The version string of the model (e.g., "v2.4").}
\item{...}{Additional elements specific to the model type:}
\itemize{
\item \strong{For \code{birdnet_model_tflite} and \code{birdnet_model_meta}:}
\itemize{
\item \code{language}: The language code used (e.g., "en_us").
\item \code{tflite_num_threads}: The number of TFLite threads used (or \code{NULL}).
}
\item \strong{For \code{birdnet_model_custom}:}
\itemize{
\item \code{classifier_folder}: Path to the custom classifier folder.
\item \code{classifier_name}: Name of the custom classifier.
\item \code{tflite_num_threads}: The number of TFLite threads used (or \code{NULL}).
}
\item \strong{For \code{birdnet_model_protobuf}:}
\itemize{
\item \code{language}: The language code used (e.g., "en_us").
\item \code{custom_device}: The custom device specified (or \code{NULL}).
}
}
}
}
\description{
The various function of the \verb{birdnet_model_*} family are used to create and initialize diffent BirdNET models. Models will be downloaded if necessary.
\itemize{
\item \code{\link[=birdnet_model_tflite]{birdnet_model_tflite()}}: creates a tflite-model used for species prediction from audio.
\item \code{\link[=birdnet_model_custom]{birdnet_model_custom()}}: loads a custom model for species prediction from audio.
\item \code{\link[=birdnet_model_protobuf]{birdnet_model_protobuf()}}: creates a protobuf model for species prediction from audio that can be run on the GPU (GPU support so far only implemented on Apple Silicon).
\item \code{\link[=birdnet_model_meta]{birdnet_model_meta()}}: creates a meta model for species prediction from location and time.
}
}
\details{
\strong{Species Prediction from audio}

Models created from \code{\link[=birdnet_model_tflite]{birdnet_model_tflite()}}, \code{\link[=birdnet_model_custom]{birdnet_model_custom()}}, and \code{\link[=birdnet_model_protobuf]{birdnet_model_protobuf()}} can be used to predict species within an audio file using \code{\link[=predict_species_from_audio_file]{predict_species_from_audio_file()}}. \cr

\strong{Species prediction from location and time}

The \code{\link[=birdnet_model_meta]{birdnet_model_meta()}} model can be used to predict species occurrence at a specific location and time of the year using \code{\link[=predict_species_at_location_and_time]{predict_species_at_location_and_time()}}.
}
\note{
Currently, all models can only be executed on the CPU. GPU support is only available on Apple Silicon.
}
\examples{
# Create a TFLite BirdNET model with 2 threads and English (US) language
\dontrun{
birdnet_model <- birdnet_model_tflite(version = "v2.4", language = "en_us", tflite_num_threads = 2)
}
}
\seealso{
\code{\link[=available_languages]{available_languages()}} \code{\link[=predict_species_from_audio_file]{predict_species_from_audio_file()}} \code{\link[=predict_species_at_location_and_time]{predict_species_at_location_and_time()}}
}
