% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_attributes.R
\name{sniff_groups_attributes}
\alias{sniff_groups_attributes}
\title{Calculate and Visualize Group Attributes from Scientific Networks}
\usage{
sniff_groups_attributes(
  groups,
  growth_rate_period = 2010:2022,
  horizon_plot = TRUE,
  show_results = TRUE,
  assign_result = NULL
)
}
\arguments{
\item{groups}{A list containing network data with publications by year and group information.
Must include elements: \code{network}, \code{pubs_by_year}, and \code{aggregate}.}

\item{growth_rate_period}{Numeric vector of years to use for growth rate calculation
(default: 2010:2024).}

\item{horizon_plot}{Logical indicating whether to include horizon plots in the output table
(default: TRUE).}

\item{show_results}{Logical indicating whether to print results to console (default: TRUE).}

\item{assign_result}{Character string specifying a variable name to assign the results to
in the global environment (default: NULL).}
}
\value{
A list with two components:
\itemize{
\item \code{attributes_table}: A gt table showing group attributes including growth rates
\item \code{regression}: A list of model summaries for each group's growth rate calculation
}
}
\description{
This function analyzes publication growth rates and other attributes for research groups
identified in scientific networks. It calculates growth rates using exponential models,
creates horizon plots for visualization, and generates summary tables.
}
\details{
The function performs the following steps:
\enumerate{
\item Calculates growth rates using exponential models for each group
\item Processes publication age and doubling time metrics
\item Optionally creates horizon plots for each group's publication trend
\item Generates a comprehensive summary table
}
}
\examples{
\dontrun{
# Assuming groups is output from sniff_groups()
groups_attributes <- sniff_groups_attributes(groups,
  growth_rate_period = 2010:2022,
  horizon_plot = TRUE
)

# View the results table
print(groups_attributes$attributes_table)

# Access model summaries
groups_attributes$regression
}

}
