% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_trajectories_lines_2d.R
\name{plot_group_trajectories_lines_2d}
\alias{plot_group_trajectories_lines_2d}
\title{Plot 2D trajectories as variable-width lines}
\usage{
plot_group_trajectories_lines_2d(
  traj_data,
  traj_filtered,
  title = "Main trajectories",
  width_range = c(0.8, 6),
  use_raw_papers = FALSE,
  label_nudge_x = 0.3,
  label_size = 4,
  show_only_highlighted = FALSE,
  lowlight_width = 0.9,
  lowlight_alpha = 0.22,
  lowlight_color = "#9AA5B1"
)
}
\arguments{
\item{traj_data}{List containing trajectory data generated by
\code{detect_main_trajectories()} with components:
\itemize{
\item \code{graph}: igraph object containing nodes and edges across years
\item \code{trajectories}: tibble of all candidate trajectories (traj_id + nodes list)
}}

\item{traj_filtered}{Filtered trajectories tibble from \code{filter_trajectories()}
containing the subset to emphasize. Must contain columns:
\itemize{
\item \code{traj_id}: trajectory identifiers
\item \code{nodes}: list of character vectors (ordered by time or orderable)
}}

\item{title}{Plot title (default: "Main trajectories")}

\item{width_range}{Range for edge widths of highlighted trajectories
(default: c(0.8, 6.0)). Width at each segment is scaled by cumulative
paper count up to the next node.}

\item{use_raw_papers}{Whether to use raw paper counts for width scaling
(default: FALSE). If TRUE, uses raw \code{quantity_papers}; if FALSE, uses
weighted size: \code{quantity_papers * prop_tracked_intra_group}.}

\item{label_nudge_x}{Horizontal nudge for trajectory end labels to prevent
overlap with nodes (default: 0.30)}

\item{label_size}{Text size for trajectory end labels (default: 4)}

\item{show_only_highlighted}{Whether to show only highlighted trajectories
(default: FALSE). If TRUE, hides all non-highlighted trajectory lines;
if FALSE, draws lowlight background.}

\item{lowlight_width}{Line width for lowlight (background) edges
(default: 0.9)}

\item{lowlight_alpha}{Transparency for lowlight edges (default: 0.22;
smaller values = more transparent)}

\item{lowlight_color}{Color for lowlight edges (default: "#9AA5B1" - neutral gray)}
}
\value{
A ggplot object displaying the trajectory network
}
\description{
Creates a 2D line plot showing research trajectories over time, with highlighted
trajectories displayed as variable-width lines and optional background trajectories
shown in lowlight style. Edge widths grow along each highlighted trajectory based
on cumulative paper counts, and labels are placed at trajectory endpoints.
}
\details{
This function visualizes research trajectories as variable-width lines:
\itemize{
\item \strong{Highlighted trajectories} (\code{traj_filtered}) are colored lines with widths
proportional to cumulative paper counts (raw or weighted)
\item \strong{Background trajectories} (when \code{show_only_highlighted = FALSE}) are shown
as thin, transparent lines
\item \strong{Trajectory labels} are placed at the end of each highlighted trajectory
\item The \strong{x-axis represents publication years} using a Sugiyama layout
\item The \strong{y-axis shows vertical positions} from the layout (no intrinsic meaning)
\item Colors are assigned only to highlighted trajectories present in the plot
}

When \code{traj_data$trajectories} is available and \code{show_only_highlighted = FALSE},
the lowlight layer shows only edges that belong to any trajectory but not the
highlighted set. Otherwise, it shows the entire graph minus highlighted edges.
}
\examples{
\dontrun{
# Detect main trajectories first
traj_data <- detect_main_trajectories(your_graph_data)

# Filter trajectories of interest
filtered_traj <- filter_trajectories(traj_data$trajectories, 
                                     min_papers = 10)

# Create the plot
plot_group_trajectories_lines_2d(
  traj_data = traj_data,
  traj_filtered = filtered_traj,
  title = "Key Research Trajectories",
  width_range = c(1, 8),
  show_only_highlighted = FALSE
)
}

}
