% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nadayara.R
\name{nadayara_regression}
\alias{nadayara_regression}
\title{nadayara_regression}
\usage{
nadayara_regression(data, response)
}
\arguments{
\item{data}{A biosensor object.}

\item{response}{The name of the scalar response. The response must be a column name in data$variables.}
}
\value{
An object of class bnadaraya:
\code{prediction} The Nadaraya-Watson prediction for each point of the training data at each h=seq(0.8, 15, length=200).
\code{r2} R2 estimation for the training data at each h=seq(0.8, 15, length=200).
\code{error} Standard mean-squared error after applying leave-one-out cross-validation for the training data at each h=seq(0.8, 15, length=200).
\code{data} A data frame with biosensor raw data.
\code{response} The name of the scalar response.
}
\description{
Functional non-parametric Nadaraya-Watson regression with 2-Wasserstein distance, using as predictor the distributional representation and as response a scalar outcome.
}
\examples{
# Data extracted from the paper: Hall, H., Perelman, D., Breschi, A., Limcaoco, P., Kellogg, R.,
# McLaughlin, T., Snyder, M., Glucotypes reveal new patterns of glucose dysregulation, PLoS
# biology 16(7), 2018.
file1 = system.file("extdata", "data_1.csv", package = "biosensors.usc")
file2 = system.file("extdata", "variables_1.csv", package = "biosensors.usc")
data = load_data(file1, file2)
nada = nadayara_regression(data, "BMI")
}
