% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{generate_data}
\alias{generate_data}
\title{generate_data}
\usage{
generate_data(n = 100, Qp = 100, Xp = 5)
}
\arguments{
\item{n}{Sample size.}

\item{Qp}{Dimension of the quantile.}

\item{Xp}{Dimension of covariates where X_i~Unif(0,1).}
}
\value{
A biosensor object:
\code{data} NULL.
\code{densities} NULL.
\code{quantiles} A functional data object (fdata) with the empirical quantile estimation.
\code{variables} A data frame with Xp covariates.
}
\description{
Generates a quantile regression model V + V2 * v + tau * V2 * Q0 where Q0 is a truncated random variable, v = 2 * X, tau = 2 * X, V ~ Unif(-1, 1), V2 ~ Unif(-1, -1), V3 ~ Unif(0.8, 1.2), and E(V|X) = tau * Q0;
}
\examples{
data = generate_data(n=100, Qp=100, Xp=5)
names(data)
head(data$quantiles)
head(data$variables)
plot(data$quantiles, main="Quantile curves")
}
