% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr_crit.R
\name{distr_crit}
\alias{distr_crit}
\title{Compute criterion distribution}
\usage{
distr_crit(target, feature, criterion = "ig", iter_limit = 200)
}
\arguments{
\item{target}{\{0,1\}-valued target vector. See Details.}

\item{feature}{\{0,1\}-valued feature vector. See Details.}

\item{criterion}{criterion used for calculations of distribution. 
See \code{\link{calc_criterion}} for the list of avaible criteria.}

\item{iter_limit}{limit the number of calculated contingence matrices. If
\code{NULL}, computes all possible contingence matrices.}
}
\value{
An object of class \code{\link{criterion_distribution}}.
}
\description{
Computes criterion distribution under null hypothesis for all contingency 
tables possible for a feature and a target.
}
\details{
both \code{target} and \code{feature} vectors may contain only 0 
and 1.
}
\examples{
target_feature <- create_feature_target(10, 375, 15, 600) 
distr_crit(target = target_feature[,1], feature = target_feature[,2])
}
\seealso{
\code{\link{calc_criterion}}.
}
\keyword{distribution}
