% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_watbal_raster.R
\name{watbalRaster}
\alias{watbalRaster}
\title{Water balance in raster format}
\usage{
watbalRaster(temp, prec, PET = NULL, CC, path = NULL, ncpu = 2)
}
\arguments{
\item{temp}{SpatRaster containing 12 layers with monthly temperature from January to December.}

\item{prec}{SpatRaster containing 12 layers with monthlyprecipitation from January to December.}

\item{PET}{Optional. Potential evapotranspiration in raster format.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. 400 as default value. It can be a SpatRaster layer.}

\item{path}{Optional. Path (folder) where the output raster files and look-up-tables will be saved.}

\item{ncpu}{Number of cores used for the most demanding calculations.}
}
\value{
SpatRaster with 144 layers corresponding to the 12 monthly values of 'temp', 'prec','PET','P_PET','PPA','ST','i_ST','RET','HD','HEX','r','rP'.
}
\description{
Computes water balance from temperature and precipitation in raster format.
}
\examples{
\donttest{
tmp <- terra::rast(tmpRast)
pre <- terra::rast(preRast)
wb <- watbalRaster(tmp, pre, PET = NULL, CC = 400, path=NULL, ncpu = 2)
}
}
