% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caltheta.R
\name{caltheta}
\alias{caltheta}
\title{Calculates the angle of convergence}
\usage{
caltheta(fixdist, pd = NULL, gender = NULL, eye = c("left", "right"))
}
\arguments{
\item{fixdist}{A two element vector of fixation distance in mm in Cartesian coordinates.}

\item{pd}{A number of pupil distance in mm.}

\item{gender}{A string of either "male" or "female"}

\item{eye}{A string specifying either "left" or "right" eye.}
}
\value{
The angle of convergence in radians that respective eye with a pupil distance of \code{pd} rolls to fixate at fixation distance of \code{fixdist}.
}
\description{
\code{caltheta} calculates the angle of convergence (radians) for left or right eye to fixate at a designated fixation distance.
}
\section{Warning}{

the value of either pd or gender has to be provided
the unit of pd and fixdist must be the same and is default to mm.
}

\examples{
caltheta(c(600, 0), pd=65, eye="left")
caltheta(c(600, 0), gender="male", eye="left")
}
