% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opCharMethodFunctions.R
\name{ExpTests.opChar}
\alias{ExpTests.opChar}
\title{Extract the expected number of tests from testing configuration results}
\usage{
\method{ExpTests}{opChar}(object, ...)
}
\arguments{
\item{object}{An object of class "opChar", from which the expected number
of tests and expected number of tests per individual are to be extracted.}

\item{...}{Additional arguments to be passed to \code{ExpTests} (e.g.,
\code{digits} to be passed to \code{round} for appropriate rounding).}
}
\value{
A data frame containing the columns:
\item{ExpTests}{the expected number of tests required to decode all individuals
in the algorithm.}
\item{ExpTestsPerIndividual}{the expected number of tests per individual.}
\item{PercentReductionTests}{The percent reduction in the number of tests; 100 * (1 - ExpTestsPerIndividual).}
\item{PercentIncreaseTestCap}{The percent increase in testing capacity when the algorithm
  is applied to a continuous stream of specimens; 100 * (1/ExpTestsPerIndividual - 1).}
}
\description{
Extract the expected number of tests and expected number of
tests per individual from objects of class "opchar" returned by
\code{\link{operatingCharacteristics1}} (\kbd{opChar1})
or \code{\link{operatingCharacteristics2}} (\kbd{opChar2}).
}
\examples{
config.mat <- matrix(data = c(rep(1, 10), 1:10),
                     nrow = 2, ncol = 10, byrow = TRUE)
res1 <- opChar1(algorithm = "D2", p = 0.05, Se = 0.99, Sp = 0.99,
                hier.config = config.mat)
ExpTests(res1)

res2 <- opChar2(algorithm = "A2M", p.vec = c(0.92, 0.05, 0.02, 0.01),
                Se = rep(0.95, 2), Sp = rep(0.99, 2), rowcol.sz = 8)
ExpTests(res2)
}
\references{
\insertRef{bilder2020tests}{binGroup2}
}
\author{
Brianna D. Hitt and Christopher R. Bilder
}
