% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_merge.R
\name{bdm.merge.s2nr}
\alias{bdm.merge.s2nr}
\title{Merging of clusters based on signal-to-noise-ratio.}
\usage{
bdm.merge.s2nr(bdm, k = 10, plot.merge = T, ret.merge = F,
  info = T, layer = 1, ...)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{k}{The number of desired clusters. The clustering will be recursively merged until reaching this number of clusters (default value is \code{k = 10}). By setting \code{k < 0} we can specify the number of clusters that we are willing to merge.}

\item{plot.merge}{Logical value. If TRUE, the merged clustering is plotted (default value is \code{plot.merge = TRUE})}

\item{ret.merge}{Logical value. If TRUE, the function returns a copy of the input \var{bdm} instance with the merged clustering attached as \var{bdm$merge} (default value is \code{ret.merge = FALSE})}

\item{info}{Logical value. If TRUE, all merging steps are shown (default value is \code{info = FALSE}).}

\item{layer}{The \var{bdm$ptsne} layer to be used (default value is \code{layer = 1}).}

\item{...}{If \var{plot.merge} is TRUE, you can set the \code{bdm.wtt.plot()} parameters to control the plot.}
}
\value{
None if \code{ret.merge = FALSE}. Else, a copy of the input \var{bdm} instance with new element \var{bdm$merge}.
}
\description{
Performs a recursive merging of clusters based on minimum loss of signal-to-noise-ratio (S2NR) until reaching the desired number of clusters. The S2NR is the explained/unexplained variance ratio measured in the high dimensional space based on the given low dimensional clustering.
}
\details{
See details in \code{bdm.optk.s2nr()}.
}
\examples{

bdm.example()
exMap.labels <- bdm.labels(exMap)
}
