% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_perc_bc_ci.R
\name{bfa_perc_bc_ci}
\alias{bfa_perc_bc_ci}
\title{Bias Correction Percentile Confidence Interval Function}
\usage{
bfa_perc_bc_ci(z, a1_ls, a1_ls_star, conf_level = 0.95)
}
\arguments{
\item{z}{a numeric vector containing the tree data.}

\item{a1_ls}{A numeric value of the least squares estimator of bifurcating autoregressive model}

\item{a1_ls_star}{A numeric vector representing B replicates of the least squares estimator}

\item{conf_level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
A numeric vector representing the lower and upper limits of the bias corrected percentile
confidence interval for the autoregressive coefficients of BAR model.
}
\description{
This function calculates the Bias-Corrected percentile CI for the least
squares estimator of the bifurcating autoregressive model.
}
\examples{
# Generating Non-contaminated normal BAR(1) tree and calculating the bias
# corrected percentile CI for the autoregressive coefficients of the BAR(1) model
z <- bfa_tree_gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
a1_ls <- bfa_ls(z,1)$coef[2]
a1_ls_star <- (rnorm(100,0.7,0.05))
bfa_perc_bc_ci(z, a1_ls, a1_ls_star, conf_level=0.95)
}
