% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{extract_session_id_from_span}
\alias{extract_session_id_from_span}
\title{Extract session ID from span attributes}
\usage{
extract_session_id_from_span(span_attributes)
}
\arguments{
\item{span_attributes}{List or data frame of span attributes}
}
\value{
Character session ID, or NA if not found
}
\description{
Extracts the session.id attribute from OTLP span attributes list.
Handles both nested list and data frame formats.
}
\examples{
\dontrun{
# from list format
attrs <- list(
  list(key = "session.id", value = list(stringValue = "abc123"))
)
extract_session_id_from_span(attrs) # returns "abc123"
}
}
\keyword{internal}
