% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R
\name{sessions}
\alias{sessions}
\alias{sessions.bids_project}
\title{Get sessions from a BIDS project}
\usage{
sessions(x, ...)

\method{sessions}{bids_project}(x, ...)
}
\arguments{
\item{x}{the object to extract sessions from}

\item{...}{extra args passed to methods}
}
\value{
A character vector of unique session IDs if the project has sessions,
or NULL if the project does not have sessions
}
\description{
This function retrieves a vector of session IDs from a BIDS project.
Sessions in BIDS are typically represented as directories named 'ses-XX'
within subject directories. This function extracts and returns the unique
session identifiers.
}
\examples{
\donttest{
# Get sessions from a BIDS project
tryCatch({
  ds007_path <- get_example_bids_dataset("ds007")
  proj <- bids_project(ds007_path)
  sessions(proj)
  
  # Dataset cache is intentionally retained for performance.
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
