% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_bids.R
\name{participants.mock_bids_project}
\alias{participants.mock_bids_project}
\title{Get Participants from Mock BIDS Project}
\usage{
\method{participants}{mock_bids_project}(x, ...)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{...}{Extra arguments (ignored).}
}
\value{
Character vector of unique participant IDs (e.g., c("01", "02")), sorted.
}
\description{
Extracts the unique participant IDs from the mock project definition.
Note: Returns IDs \emph{without} the "sub-" prefix for consistency with \code{bids_project} methods.
}
\examples{
# Create a mock project
parts <- data.frame(participant_id = c("sub-01", "sub-02"))
fs <- data.frame(subid=c("01", "02"), datatype="func", suffix="bold.nii.gz", fmriprep=FALSE)
mock_proj <- create_mock_bids("SimpleMock", parts, fs)

# Get participant IDs
participants(mock_proj)
}
